/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.entity;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.missiles.cause.IMissileSource;
import icbm.classic.api.missiles.parts.IMissileFlightLogic;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.ConfigDebug;
import icbm.classic.content.missile.entity.EntityMissile;
import icbm.classic.content.missile.logic.source.MissileSource;
import icbm.classic.lib.CalculationHelpers;
import icbm.classic.lib.radar.RadarRegistry;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.saving.NbtSaveNode;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.INBTSerializable;

public class CapabilityMissile
implements IMissile,
INBTSerializable<NBTTagCompound> {
    private final EntityMissile missile;
    private IMissileTarget targetData;
    private IMissileSource firingSource;
    private IMissileFlightLogic flightLogic;
    private boolean doFlight = false;
    private static final NbtSaveHandler<CapabilityMissile> SAVE_LOGIC = new NbtSaveHandler().addRoot("flags").nodeBoolean("doFlight", CapabilityMissile::canRunFlightLogic, (cap, i) -> {
        cap.doFlight = i;
    }).base().mainRoot().node(new NbtSaveNode<CapabilityMissile, NBTTagCompound>("target", cap -> {
        if (cap.getTargetData() != null) {
            if (cap.getTargetData().getRegistryName() != null) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                NBTTagCompound logicSave = (NBTTagCompound)cap.getTargetData().serializeNBT();
                if (logicSave != null && !logicSave.func_82582_d()) {
                    tagCompound.func_74782_a("data", (NBTBase)logicSave);
                }
                tagCompound.func_74778_a("id", cap.getTargetData().getRegistryName().toString());
                return tagCompound;
            }
            return (NBTTagCompound)cap.getTargetData().serializeNBT();
        }
        return null;
    }, (cap, data) -> {
        if (cap.getTargetData() == null) {
            ResourceLocation saveId = new ResourceLocation(data.func_74779_i("id"));
            IMissileTarget target = ICBMClassicAPI.MISSILE_TARGET_DATA_REGISTRY.build(saveId);
            if (target != null) {
                if (data.func_74764_b("data")) {
                    target.deserializeNBT((NBTBase)data.func_74775_l("data"));
                }
                cap.setTargetData(target);
            }
        } else {
            cap.getTargetData().deserializeNBT((NBTBase)data);
        }
    })).node(new NbtSaveNode<CapabilityMissile, NBTTagCompound>("flight", missile -> {
        NBTTagCompound save = new NBTTagCompound();
        IMissileFlightLogic logic = missile.getFlightLogic();
        if (logic != null) {
            NBTTagCompound logicSave = (NBTTagCompound)logic.serializeNBT();
            if (logicSave != null && !logicSave.func_82582_d()) {
                save.func_74782_a("data", (NBTBase)logicSave);
            }
            save.func_74778_a("id", logic.getRegistryName().toString());
        }
        return save;
    }, (missile, data) -> {
        ResourceLocation saveId = new ResourceLocation(data.func_74779_i("id"));
        IMissileFlightLogic logic = ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY.build(saveId);
        if (logic != null) {
            if (data.func_74764_b("data")) {
                logic.deserializeNBT((NBTBase)data.func_74775_l("data"));
            }
            missile.setFlightLogic(logic);
        }
    })).node(new NbtSaveNode<CapabilityMissile, NBTTagCompound>("source", missile -> {
        NBTTagCompound save = new NBTTagCompound();
        IMissileSource source = missile.getMissileSource();
        if (source != null) {
            return (NBTTagCompound)source.serializeNBT();
        }
        return save;
    }, (missile, data) -> {
        MissileSource source = new MissileSource();
        if (data.func_74764_b("data")) {
            source.deserializeNBT((NBTBase)data.func_74775_l("data"));
        } else {
            source.deserializeNBT((NBTBase)data);
        }
    })).base();

    public CapabilityMissile(EntityMissile missile) {
        this.missile = missile;
    }

    @Override
    public int getTicksInAir() {
        return this.missile.ticksInAir;
    }

    @Override
    public Entity getMissileEntity() {
        return this.missile;
    }

    @Override
    public void setTargetData(IMissileTarget data) {
        this.targetData = data;
    }

    @Override
    public IMissileTarget getTargetData() {
        return this.targetData;
    }

    @Override
    public void setFlightLogic(IMissileFlightLogic logic) {
        this.missile.syncClient = true;
        this.flightLogic = logic;
    }

    @Override
    public void switchFlightLogic(IMissileFlightLogic logic) {
        if (ConfigDebug.DEBUG_MISSILE_LOGIC) {
            ICBMClassic.logger().info(this + ": Switching flight logic from '" + this.getFlightLogic() + "' to '" + logic + "'");
        }
        this.setFlightLogic(logic);
        this.triggerFlightLogic();
    }

    protected void triggerFlightLogic() {
        if (this.flightLogic != null) {
            this.flightLogic.calculateFlightPath(this.world(), this.x(), this.y(), this.z(), this.getTargetData());
            this.flightLogic.start(this.missile, this);
        }
    }

    @Override
    public IMissileFlightLogic getFlightLogic() {
        return this.flightLogic;
    }

    @Override
    public void setMissileSource(IMissileSource source) {
        this.firingSource = source;
    }

    @Override
    public IMissileSource getMissileSource() {
        return this.firingSource;
    }

    @Override
    public void launch() {
        this.doFlight = true;
        this.triggerFlightLogic();
        ICBMClassicAPI.EX_MISSILE_REGISTRY.triggerLaunch(this);
        RadarRegistry.add(this.missile);
        ICBMSounds.MISSILE_LAUNCH.play(this.world(), this.x(), this.y(), this.z(), 1.0f, (1.0f + CalculationHelpers.randFloatRange(this.world().field_73012_v, 0.2f)) * 0.7f, true);
        if (ConfigDebug.DEBUG_MISSILE_LAUNCHES) {
            ICBMClassic.logger().info(String.format("Missile(%s): Launch triggered of type[%s] starting from '%s' and aimed at `%s`", this.missile.func_145782_y(), this.missile.func_70005_c_(), Optional.ofNullable(this.getMissileSource()).map(Objects::toString).orElse("'null'"), Optional.ofNullable(this.getTargetData()).map(Objects::toString).orElse("'null'")));
        }
    }

    @Override
    public World world() {
        return this.missile != null ? this.missile.field_70170_p : null;
    }

    @Override
    public double z() {
        return this.missile != null ? this.missile.field_70161_v : 0.0;
    }

    @Override
    public double x() {
        return this.missile != null ? this.missile.field_70165_t : 0.0;
    }

    @Override
    public double y() {
        return this.missile != null ? this.missile.field_70163_u : 0.0;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IMissile.class, (Capability.IStorage)new Capability.IStorage<IMissile>(){

            @Nullable
            public NBTBase writeNBT(Capability<IMissile> capability, IMissile instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IMissile> capability, IMissile instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> new CapabilityMissile(null));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound saveData = new NBTTagCompound();
        SAVE_LOGIC.save(this, saveData);
        return saveData;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    public boolean canRunFlightLogic() {
        return this.doFlight;
    }

    public int hashCode() {
        return this.missile != null ? this.missile.hashCode() : super.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof CapabilityMissile) {
            return Objects.equals(((CapabilityMissile)other).flightLogic, this.flightLogic) && Objects.equals(((CapabilityMissile)other).targetData, this.targetData) && ((CapabilityMissile)other).doFlight == this.doFlight;
        }
        return false;
    }
}

