/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.flight;

import icbm.classic.ICBMClassic;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.content.missile.logic.flight.prefab.FlightLogic;
import icbm.classic.lib.saving.NbtSaveHandler;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class WarmupFlightLogic
extends FlightLogic {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "engine.warmup");
    private int timer = 0;
    private static final NbtSaveHandler<WarmupFlightLogic> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeInteger("timer", bl -> null, (bl, data) -> {
        bl.timer = data;
    }).base();

    @Override
    protected void dumpInformation(Consumer<String> outputLines) {
        super.dumpInformation(outputLines);
        outputLines.accept("\tTimer: " + this.timer);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return REG_NAME;
    }

    @Override
    public void onEntityTick(Entity entity, IMissile missile, int ticksInAir) {
        super.onEntityTick(entity, missile, ticksInAir);
        if (--this.timer > 0) {
            ICBMClassic.proxy.spawnPadSmoke(entity, this, ticksInAir);
        }
    }

    @Override
    public boolean shouldDecreaseMotion(Entity entity) {
        return this.timer < 0 && this.getNextStep() == null;
    }

    @Override
    public boolean isDone() {
        return this.timer <= 0;
    }

    @Override
    public boolean shouldRunEngineEffects(Entity entity) {
        return this.timer < 0;
    }

    @Override
    public boolean canSafelyExitLogic() {
        return this.timer < 0;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, super.serializeNBT());
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public int getTimer() {
        return this.timer;
    }

    @Generated
    public WarmupFlightLogic setTimer(int timer) {
        this.timer = timer;
        return this;
    }
}

