/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.source.cause;

import icbm.classic.api.missiles.cause.IMissileCause;
import icbm.classic.content.missile.logic.source.cause.MissileCause;
import icbm.classic.lib.saving.NbtSaveHandler;
import lombok.Generated;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class BlockCause
extends MissileCause
implements IMissileCause.IBlockCause {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "block");
    private World world;
    private BlockPos blockPos;
    private IBlockState blockState;
    private int worldId;
    private static final NbtSaveHandler<BlockCause> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeInteger("level", BlockCause::getWorldId, BlockCause::setWorldId).nodeBlockPos("pos", BlockCause::getBlockPos, BlockCause::setBlockPos).nodeBlockState("state", BlockCause::getBlockState, BlockCause::setBlockState).base();

    public BlockCause(World world, BlockPos pos, IBlockState state) {
        this.world = world;
        this.worldId = world.field_73011_w.getDimension();
        this.blockPos = pos;
        this.blockState = state;
    }

    @Override
    public World getWorld() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld((int)this.worldId);
        }
        return this.world;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return REG_NAME;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, super.serializeNBT());
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Override
    @Generated
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Override
    @Generated
    public IBlockState getBlockState() {
        return this.blockState;
    }

    @Generated
    public int getWorldId() {
        return this.worldId;
    }

    @Generated
    public void setWorld(World world) {
        this.world = world;
    }

    @Generated
    public void setBlockPos(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    @Generated
    public void setBlockState(IBlockState blockState) {
        this.blockState = blockState;
    }

    @Generated
    public void setWorldId(int worldId) {
        this.worldId = worldId;
    }

    @Generated
    public String toString() {
        return "BlockCause(world=" + this.getWorld() + ", blockPos=" + this.getBlockPos() + ", blockState=" + this.getBlockState() + ", worldId=" + this.getWorldId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockCause)) {
            return false;
        }
        BlockCause other = (BlockCause)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getWorldId() != other.getWorldId()) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        BlockPos this$blockPos = this.getBlockPos();
        BlockPos other$blockPos = other.getBlockPos();
        if (this$blockPos == null ? other$blockPos != null : !this$blockPos.equals(other$blockPos)) {
            return false;
        }
        IBlockState this$blockState = this.getBlockState();
        IBlockState other$blockState = other.getBlockState();
        return !(this$blockState == null ? other$blockState != null : !this$blockState.equals(other$blockState));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BlockCause;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getWorldId();
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        BlockPos $blockPos = this.getBlockPos();
        result = result * 59 + ($blockPos == null ? 43 : $blockPos.hashCode());
        IBlockState $blockState = this.getBlockState();
        result = result * 59 + ($blockState == null ? 43 : $blockState.hashCode());
        return result;
    }

    @Generated
    public BlockCause() {
    }
}

