/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.capability.emp;

import icbm.classic.ICBMClassic;
import icbm.classic.api.caps.IEMPReceiver;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.config.ConfigEMP;
import icbm.classic.lib.InventoryUtility;
import icbm.classic.lib.capability.emp.CapabilityEMP;
import icbm.classic.lib.energy.system.EnergySystem;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class CapabilityEmpInventory<H>
implements IEMPReceiver {
    @Override
    public float applyEmpAction(World world, double x, double y, double z, IBlast emp_blast, float power, boolean doAction) {
        IItemHandlerModifiable iItemHandler = this.getCapability();
        if (iItemHandler != null) {
            for (int slotIndex = 0; slotIndex < iItemHandler.getSlots(); ++slotIndex) {
                ItemStack slotStack = iItemHandler.getStackInSlot(slotIndex);
                if (slotStack.func_190926_b()) continue;
                ItemStack itemStack = slotStack.func_77946_l();
                power = CapabilityEmpInventory.empItemStack(itemStack, world, x, y, z, this.getHost(), emp_blast, power, doAction);
                if (!doAction || InventoryUtility.stacksMatchExact(itemStack, slotStack)) continue;
                try {
                    iItemHandler.setStackInSlot(slotIndex, itemStack);
                    continue;
                }
                catch (RuntimeException e) {
                    ICBMClassic.logger().error("BlastEMP: Unexpected error while updating inventory item '" + itemStack + "' from slot '" + slotIndex + "' in '" + iItemHandler + "' contained in '" + this.getHost() + "' while running " + this, (Throwable)e);
                }
            }
        }
        return power;
    }

    public static float empItemStack(ItemStack itemStack, World world, double x, double y, double z, Object container, IBlast emp_blast, float power, boolean doAction) {
        boolean doInventory = ConfigEMP.ALLOW_ITEM_INVENTORY;
        if (itemStack.hasCapability(CapabilityEMP.EMP, null)) {
            IEMPReceiver cap = (IEMPReceiver)itemStack.getCapability(CapabilityEMP.EMP, null);
            if (cap != null) {
                power = cap.applyEmpAction(world, x, y, z, emp_blast, power, true);
                doInventory = cap.shouldEmpSubObjects(world, x, y, z) && doInventory;
            }
        } else if (ConfigEMP.DRAIN_ENERGY_ITEMS) {
            EnergySystem.getSystem(itemStack, null).setEnergy(itemStack, null, 0, false);
        }
        if (doInventory && itemStack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            if (container instanceof Entity) {
                power = new ItemInvInEntity((Entity)container, itemStack).applyEmpAction(world, x, y, z, emp_blast, power, doAction);
            } else if (container instanceof TileEntity) {
                power = new ItemInvInTile((TileEntity)container, itemStack).applyEmpAction(world, x, y, z, emp_blast, power, doAction);
            }
        }
        return power;
    }

    protected abstract IItemHandlerModifiable getCapability();

    protected abstract H getHost();

    public static class ItemInvInTile
    extends CapabilityEmpInventory<TileEntity> {
        public final ItemStack item;
        public final TileEntity host;

        public ItemInvInTile(TileEntity host, ItemStack item) {
            this.host = host;
            this.item = item;
        }

        @Override
        protected IItemHandlerModifiable getCapability() {
            IItemHandler handler;
            if (ConfigEMP.ALLOW_ITEM_INVENTORY && this.item.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (handler = (IItemHandler)this.item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) instanceof IItemHandlerModifiable) {
                return (IItemHandlerModifiable)handler;
            }
            return null;
        }

        @Override
        protected TileEntity getHost() {
            return this.host;
        }
    }

    public static class ItemInvInEntity
    extends CapabilityEmpInventory<Entity> {
        public final ItemStack item;
        public final Entity host;

        public ItemInvInEntity(Entity host, ItemStack item) {
            this.host = host;
            this.item = item;
        }

        @Override
        protected IItemHandlerModifiable getCapability() {
            IItemHandler handler;
            if (ConfigEMP.ALLOW_ITEM_INVENTORY && this.item.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (handler = (IItemHandler)this.item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) instanceof IItemHandlerModifiable) {
                return (IItemHandlerModifiable)handler;
            }
            return null;
        }

        @Override
        protected Entity getHost() {
            return this.host;
        }
    }

    public static class TileInv
    extends CapabilityEmpInventory<TileEntity> {
        public final TileEntity entity;

        public TileInv(TileEntity entity) {
            this.entity = entity;
        }

        @Override
        protected IItemHandlerModifiable getCapability() {
            IItemHandler handler;
            if (ConfigEMP.ALLOW_TILE_INVENTORY && this.entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (handler = (IItemHandler)this.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) instanceof IItemHandlerModifiable) {
                return (IItemHandlerModifiable)handler;
            }
            return null;
        }

        @Override
        protected TileEntity getHost() {
            return this.entity;
        }
    }

    public static class EntityInv
    extends CapabilityEmpInventory<Entity> {
        public final Entity entity;

        public EntityInv(Entity entity) {
            this.entity = entity;
        }

        @Override
        protected IItemHandlerModifiable getCapability() {
            IItemHandler handler;
            if (ConfigEMP.ALLOW_ENTITY_INVENTORY && this.entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (handler = (IItemHandler)this.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) instanceof IItemHandlerModifiable) {
                return (IItemHandlerModifiable)handler;
            }
            return null;
        }

        @Override
        protected Entity getHost() {
            return this.entity;
        }
    }
}

