/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network.lambda.tile;

import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.PacketEvents;
import icbm.classic.lib.network.lambda.PacketCodex;
import icbm.classic.lib.network.lambda.PacketCodexReg;
import icbm.classic.lib.network.lambda.tile.PacketCodexTile;
import icbm.classic.lib.network.lambda.tile.PacketTileEvents;
import icbm.classic.lib.tracker.EventTrackerHelpers;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketLambdaTile<TARGET>
implements IPacket<PacketLambdaTile<TARGET>> {
    private PacketCodex codex;
    private Integer dimensionId;
    private BlockPos pos;
    private List<Consumer<ByteBuf>> writers;
    private List<Consumer<TARGET>> setters;

    public PacketLambdaTile(PacketCodexTile codex, TileEntity tile, TARGET target) {
        this(codex, tile.func_145831_w(), tile.func_174877_v(), target);
    }

    public PacketLambdaTile(PacketCodexTile codex, World dimensionId, BlockPos pos, TARGET target) {
        this(codex, dimensionId, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), target);
    }

    public PacketLambdaTile(PacketCodexTile codex, World dimensionId, int x, int y, int z, TARGET target) {
        this.codex = codex;
        this.setDimensionId(dimensionId.field_73011_w.getDimension());
        this.setPos(new BlockPos(x, y, z));
        this.writers = codex.encodeAsWriters(target);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.codex.getId());
        buffer.writeInt(this.dimensionId.intValue());
        buffer.writeInt(this.pos.func_177958_n());
        buffer.writeInt(this.pos.func_177956_o());
        buffer.writeInt(this.pos.func_177952_p());
        this.writers.forEach(c -> c.accept(buffer));
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.codex = PacketCodexReg.get(buffer.readInt());
        this.dimensionId = buffer.readInt();
        this.pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        this.setters = this.codex.decodeAsSetters(buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(Minecraft minecraft, EntityPlayer player) {
        int playerDim = player.field_70170_p.field_73011_w.getDimension();
        if (playerDim != this.getDimensionId()) {
            PacketEvents.onWrongWorld(this.codex, EventTrackerHelpers.SIDE_CLIENT, this.getDimensionId(), playerDim);
            return;
        }
        World world = player.field_70170_p;
        minecraft.func_152344_a(() -> this.loadDataIntoTile(world, player));
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        int playerDim = player.field_70170_p.field_73011_w.getDimension();
        if (playerDim != this.getDimensionId()) {
            PacketEvents.onWrongWorld(this.codex, EventTrackerHelpers.SIDE_SERVER, this.getDimensionId(), playerDim);
            return;
        }
        if (!(player.field_70170_p instanceof WorldServer)) {
            PacketEvents.onNotServerWorld(this.codex, this.getDimensionId());
            return;
        }
        WorldServer world = (WorldServer)player.field_70170_p;
        world.func_152344_a(() -> this.loadDataIntoTile((World)world, player));
    }

    private void loadDataIntoTile(World world, EntityPlayer player) {
        if (!world.func_175667_e(this.pos)) {
            return;
        }
        try {
            TileEntity tile = player.field_70170_p.func_175625_s(this.pos);
            if (tile == null || !this.codex.isValid(tile)) {
                PacketTileEvents.onInvalidTile(this.codex, world, this.pos);
                return;
            }
            Object target = this.codex.getConverter().apply(tile);
            if (target != null) {
                this.setters.forEach(c -> c.accept(target));
            }
            if (this.codex.onFinished() != null) {
                this.codex.onFinished().accept((Object)tile, target, (Object)player);
            }
        }
        catch (Exception e) {
            PacketTileEvents.onHandlingError(this.codex, world, this.pos, e);
        }
    }

    public PacketCodex getCodex() {
        return this.codex;
    }

    public Integer getDimensionId() {
        return this.dimensionId;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public List<Consumer<ByteBuf>> getWriters() {
        return this.writers;
    }

    public List<Consumer<TARGET>> getSetters() {
        return this.setters;
    }

    public void setCodex(PacketCodex codex) {
        this.codex = codex;
    }

    public void setDimensionId(Integer dimensionId) {
        this.dimensionId = dimensionId;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public void setWriters(List<Consumer<ByteBuf>> writers) {
        this.writers = writers;
    }

    public void setSetters(List<Consumer<TARGET>> setters) {
        this.setters = setters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketLambdaTile)) {
            return false;
        }
        PacketLambdaTile other = (PacketLambdaTile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$dimensionId = this.getDimensionId();
        Integer other$dimensionId = other.getDimensionId();
        if (this$dimensionId == null ? other$dimensionId != null : !((Object)this$dimensionId).equals(other$dimensionId)) {
            return false;
        }
        PacketCodex this$codex = this.getCodex();
        PacketCodex other$codex = other.getCodex();
        if (this$codex == null ? other$codex != null : !((Object)this$codex).equals(other$codex)) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        List<Consumer<ByteBuf>> this$writers = this.getWriters();
        List<Consumer<ByteBuf>> other$writers = other.getWriters();
        if (this$writers == null ? other$writers != null : !((Object)this$writers).equals(other$writers)) {
            return false;
        }
        List<Consumer<TARGET>> this$setters = this.getSetters();
        List<Consumer<TARGET>> other$setters = other.getSetters();
        return !(this$setters == null ? other$setters != null : !((Object)this$setters).equals(other$setters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PacketLambdaTile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $dimensionId = this.getDimensionId();
        result = result * 59 + ($dimensionId == null ? 43 : ((Object)$dimensionId).hashCode());
        PacketCodex $codex = this.getCodex();
        result = result * 59 + ($codex == null ? 43 : ((Object)$codex).hashCode());
        BlockPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        List<Consumer<ByteBuf>> $writers = this.getWriters();
        result = result * 59 + ($writers == null ? 43 : ((Object)$writers).hashCode());
        List<Consumer<TARGET>> $setters = this.getSetters();
        result = result * 59 + ($setters == null ? 43 : ((Object)$setters).hashCode());
        return result;
    }

    public String toString() {
        return "PacketLambdaTile(codex=" + this.getCodex() + ", dimensionId=" + this.getDimensionId() + ", pos=" + this.getPos() + ", writers=" + this.getWriters() + ", setters=" + this.getSetters() + ")";
    }

    public PacketLambdaTile() {
    }
}

