/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.projectile.vanilla;

import icbm.classic.api.missiles.projectile.IProjectileData;
import icbm.classic.lib.saving.NbtSaveHandler;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntitySpawnProjectileData
implements IProjectileData<Entity> {
    public static final ResourceLocation NAME = new ResourceLocation("minecraft", "entity");
    private ResourceLocation entityKey;
    private String displayName;
    private NBTTagCompound entityData;
    private static final NbtSaveHandler<EntitySpawnProjectileData> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeResourceLocation("entity_id", e -> e.entityKey, (e, r) -> {
        e.entityKey = r;
    }).nodeString("custom_name", EntitySpawnProjectileData::getDisplayName, EntitySpawnProjectileData::setDisplayName).nodeCompoundTag("entity_data", EntitySpawnProjectileData::getEntityData, EntitySpawnProjectileData::setEntityData).base();

    public EntitySpawnProjectileData(ResourceLocation key) {
        this.entityKey = key;
    }

    public EntitySpawnProjectileData(String name) {
        this(new ResourceLocation(name));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return NAME;
    }

    @Override
    public Entity newEntity(World world, boolean allowItemPickup) {
        EntityEntry entry;
        if (this.entityKey != null && (entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(this.entityKey)) != null) {
            Entity entity = entry.newInstance(world);
            if (entity != null) {
                if (this.displayName != null) {
                    entity.func_96094_a(this.displayName);
                }
                if (this.entityData != null) {
                    NBTTagCompound entityExistingSave = entity.func_189511_e(new NBTTagCompound());
                    UUID uuid = entity.func_110124_au();
                    entityExistingSave.func_179237_a(this.entityData);
                    entity.func_184221_a(uuid);
                    entity.func_70020_e(entityExistingSave);
                }
            }
            return entity;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public EntitySpawnProjectileData() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public EntitySpawnProjectileData setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Generated
    public NBTTagCompound getEntityData() {
        return this.entityData;
    }

    @Generated
    public EntitySpawnProjectileData setEntityData(NBTTagCompound entityData) {
        this.entityData = entityData;
        return this;
    }
}

