/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.mods.mekanism;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.network.packet.PacketEntityPos;
import icbm.classic.lib.projectile.EntityProjectile;
import icbm.classic.lib.world.IProjectileBlockInteraction;
import icbm.classic.lib.world.ProjectileBlockInteraction;
import icbm.classic.mods.ModProxy;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class MekProxy
extends ModProxy {
    public static final MekProxy INSTANCE = new MekProxy();
    private boolean isLoaded = false;
    @GameRegistry.ObjectHolder(value="mekanism:MachineBlock")
    public static Block machineBlock;
    @GameRegistry.ObjectHolder(value="mekanism:BasicBlock")
    public static Block basicBlock;

    @Override
    @Optional.Method(modid="mekanism")
    public void init() {
        this.isLoaded = true;
        ICBMClassic.logger().info("Mekanism interaction: " + machineBlock + " " + basicBlock);
        if (machineBlock != null && basicBlock != null) {
            IBlockState frameState = basicBlock.func_176203_a(7);
            ICBMClassic.logger().info("Mekanism interaction: " + frameState);
            ProjectileBlockInteraction.addBlockStateInteraction(frameState, (world, blockPos, hit, side, state, entity) -> {
                BlockPos possiblePortal = blockPos.func_177972_a(side);
                BlockPos teleporter = this.findTeleporter(world, possiblePortal);
                if (teleporter != null) {
                    this.teleport(world, teleporter, hit, entity);
                    return IProjectileBlockInteraction.EnumHitReactions.TELEPORTED;
                }
                return IProjectileBlockInteraction.EnumHitReactions.CONTINUE;
            });
        }
    }

    protected BlockPos findTeleporter(World world, BlockPos possiblePortal) {
        BlockPos optionA = possiblePortal.func_177977_b();
        if (this.isTeleporter(world.func_180495_p(optionA))) {
            return optionA;
        }
        BlockPos optionB = optionA.func_177977_b();
        if (this.isTeleporter(world.func_180495_p(optionB))) {
            return optionB;
        }
        BlockPos optionC = optionB.func_177977_b();
        if (this.isTeleporter(world.func_180495_p(optionC))) {
            return optionC;
        }
        return null;
    }

    protected void teleport(World world, BlockPos telePos, Vec3d hit, Entity entity) {
        if (entity instanceof EntityProjectile) {
            ((EntityProjectile)entity).moveTowards(hit, -0.5);
        } else {
            entity.func_70107_b((double)telePos.func_177958_n() + 0.5, (double)telePos.func_177956_o() + 1.5, (double)telePos.func_177952_p() + 0.5);
        }
        EnumFacing facingDirection = entity.func_174811_aO();
        double yOffset = entity.field_70163_u - (double)telePos.func_177956_o() - 1.0;
        TileEntity tile = world.func_175625_s(telePos);
        if (tile != null && "mekanism.common.tile.TileEntityTeleporter".equals(tile.getClass().getTypeName())) {
            Class<?> cls = tile.getClass();
            try {
                BlockPos possiblePortal;
                BlockPos teleporter;
                Method method = cls.getMethod("teleport", new Class[0]);
                method.invoke((Object)tile, new Object[0]);
                if (entity.func_70089_S() && entity.field_70170_p == world && (teleporter = this.findTeleporter(world, possiblePortal = entity.func_180425_c())) != null) {
                    EnumFacing openSide = this.getSide(world, possiblePortal);
                    if (openSide != null) {
                        entity.func_70107_b(entity.field_70165_t + (double)openSide.func_82601_c(), entity.field_70163_u + yOffset, entity.field_70161_v + (double)openSide.func_82599_e());
                        double motionX = entity.field_70159_w;
                        double motionZ = entity.field_70179_y;
                        if (facingDirection.func_176740_k() == EnumFacing.Axis.X && openSide.func_176740_k() != EnumFacing.Axis.X) {
                            entity.field_70159_w = (double)openSide.func_82601_c() * motionZ;
                            entity.field_70179_y = motionX;
                        } else if (facingDirection.func_176740_k() == EnumFacing.Axis.Z && openSide.func_176740_k() != EnumFacing.Axis.Z) {
                            entity.field_70159_w = motionZ;
                            entity.field_70179_y = (double)openSide.func_82599_e() * motionX;
                        }
                        if (entity instanceof EntityProjectile) {
                            ((EntityProjectile)entity).rotateTowardsMotion(1.0f);
                        } else {
                            float yawAdjust = this.getYaw(openSide);
                            entity.field_70177_z += yawAdjust;
                            while (entity.field_70177_z > 360.0f) {
                                entity.field_70177_z -= 360.0f;
                            }
                            while (entity.field_70177_z < -360.0f) {
                                entity.field_70177_z += 360.0f;
                            }
                        }
                        ICBMClassic.packetHandler.sendToAllAround(new PacketEntityPos(entity), world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 400.0);
                    } else {
                        entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + yOffset, entity.field_70161_v);
                    }
                }
            }
            catch (Exception e) {
                ICBMClassic.logger().error("Failed to teleport using mekanism portal", (Throwable)e);
            }
        }
    }

    protected boolean isTeleporter(IBlockState state) {
        return state.func_177230_c() == machineBlock && state.func_177230_c().func_176201_c(state) == 11;
    }

    protected EnumFacing getSide(World world, BlockPos pos) {
        for (EnumFacing side : EnumFacing.field_176754_o) {
            BlockPos sidePos = pos.func_177972_a(side);
            if (!world.func_175623_d(sidePos)) continue;
            return side;
        }
        return null;
    }

    protected float getYaw(EnumFacing side) {
        switch (side) {
            case NORTH: {
                return 180.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case EAST: {
                return 270.0f;
            }
        }
        return 0.0f;
    }

    public boolean isMekanismLoaded() {
        return this.isLoaded;
    }
}

