/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.helpers.EnumColor;
import jds.bibliocraft.helpers.EnumRelativeLocation;
import jds.bibliocraft.items.ItemRecipeBook;
import jds.bibliocraft.network.BiblioNetworking;
import jds.bibliocraft.network.packet.client.BiblioDeskOpenGui;
import jds.bibliocraft.states.TextureState;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityDesk;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockDesk
extends BiblioWoodBlock {
    public static final String name = "Desk";
    public static final BlockDesk instance = new BlockDesk();

    public BlockDesk() {
        super(name, false);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        boolean output = false;
        if (side == EnumFacing.UP) {
            output = true;
        }
        return output;
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null && tile instanceof TileEntityDesk) {
            TileEntityDesk desk = (TileEntityDesk)tile;
            EnumFacing angle = desk.getAngle();
            boolean dontOpenGui = false;
            if (player.func_70093_af()) {
                if (this.isLeftBookStack(hitX, hitZ, side, angle)) {
                    dontOpenGui = desk.removeStackFromInventoryFromWorld(desk.getLeftBookFullSlot(), player, this);
                } else if (this.isRightBookStack(hitX, hitZ, side, angle)) {
                    dontOpenGui = desk.removeStackFromInventoryFromWorld(desk.getRightBookFullSlot(), player, this);
                } else if (this.isWritingBook(hitX, hitZ, side, angle)) {
                    dontOpenGui = desk.removeStackFromInventoryFromWorld(0, player, this);
                }
                if (side != EnumFacing.UP) {
                    dontOpenGui = desk.removeStackFromInventoryFromWorld(9, player, this);
                }
            } else {
                ItemStack playerhand = player.func_184586_b(EnumHand.MAIN_HAND);
                if (playerhand != ItemStack.field_190927_a) {
                    if (!Config.isBlock(playerhand) && Config.testBookValidity(playerhand)) {
                        if (this.isLeftBookStack(hitX, hitZ, side, angle)) {
                            if (desk.getLeftBookEmptySlot() != -1) {
                                dontOpenGui = desk.addStackToInventoryFromWorld(playerhand, desk.getLeftBookEmptySlot(), player);
                            }
                        } else if (this.isRightBookStack(hitX, hitZ, side, angle)) {
                            if (desk.getLeftBookEmptySlot() != -1) {
                                dontOpenGui = desk.addStackToInventoryFromWorld(playerhand, desk.getRightBookEmptySlot(), player);
                            }
                        } else if (this.isWritingBook(hitX, hitZ, side, angle)) {
                            dontOpenGui = desk.addStackToInventoryFromWorld(playerhand, 0, player);
                        }
                    }
                    if (side != EnumFacing.UP && Block.func_149634_a((Item)playerhand.func_77973_b()) instanceof BlockCarpet) {
                        dontOpenGui = desk.addStackToInventoryFromWorldSingleStackSize(playerhand, 9, player);
                    }
                }
            }
            if (!dontOpenGui) {
                if (this.isWritingBook(hitX, hitZ, side, angle) && desk.func_70301_a(0) != ItemStack.field_190927_a) {
                    BiblioNetworking.INSTANCE.sendTo((IMessage)new BiblioDeskOpenGui(pos, desk.func_70301_a(0), desk.func_70301_a(0).func_77973_b() == ItemRecipeBook.instance ? Config.enableRecipeBookCrafting : false), (EntityPlayerMP)player);
                } else {
                    player.openGui((Object)BiblioCraft.instance, 7, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
        return true;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDesk();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add("candle");
        modelParts.add("pen");
        modelParts.add("deskTopEndRight");
        modelParts.add("deskTopEndLeft");
        modelParts.add("legLeft");
        modelParts.add("legRight");
        modelParts.add("shelfSingle");
        if (tile instanceof TileEntityDesk) {
            TileEntityDesk desk = (TileEntityDesk)tile;
            switch (desk.getSingleLeftRightCenter()) {
                case LEFT: {
                    modelParts = new ArrayList();
                    modelParts.add("deskTopRight");
                    modelParts.add("deskTopEndLeft");
                    modelParts.add("legLeft");
                    modelParts.add("shelfLeft");
                    modelParts.add("candle");
                    modelParts.add("backRight");
                    break;
                }
                case RIGHT: {
                    modelParts = new ArrayList();
                    modelParts.add("deskTopEndRight");
                    modelParts.add("deskTopLeft");
                    modelParts.add("legRight");
                    modelParts.add("shelfRight");
                    modelParts.add("pen");
                    modelParts.add("backLeft");
                    break;
                }
                case CENTER: {
                    modelParts = new ArrayList();
                    modelParts.add("deskTopRight");
                    modelParts.add("deskTopLeft");
                    modelParts.add("backBoth");
                    break;
                }
            }
            if (desk.getOpenBook() != ItemStack.field_190927_a && desk.getOpenBook().func_77973_b() != Items.field_190931_a && !desk.getHasMap()) {
                modelParts.add("bookOpen");
            }
            if (desk.getLeftBookStack() > 0) {
                modelParts.add("lbook1");
            }
            if (desk.getLeftBookStack() > 1) {
                modelParts.add("lbook2");
            }
            if (desk.getLeftBookStack() > 2) {
                modelParts.add("lbook3");
            }
            if (desk.getLeftBookStack() > 3) {
                modelParts.add("lbook4");
            }
            if (desk.getRightBookStack() > 0) {
                modelParts.add("rbook1");
            }
            if (desk.getRightBookStack() > 1) {
                modelParts.add("rbook2");
            }
            if (desk.getRightBookStack() > 2) {
                modelParts.add("rbook3");
            }
            if (desk.getRightBookStack() > 3) {
                modelParts.add("rbook4");
            }
            if (desk.func_70301_a(9) != ItemStack.field_190927_a) {
                modelParts.add("carpet");
            }
        }
        return modelParts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        return transform;
    }

    public boolean isWritingBook(float hitx, float hitz, EnumFacing face, EnumFacing angle) {
        boolean returnValue = false;
        if (face == EnumFacing.UP) {
            switch (angle) {
                case SOUTH: {
                    if (!((double)hitz > 0.2) || !((double)hitz < 0.8) || !((double)hitx < 0.5)) break;
                    returnValue = true;
                    break;
                }
                case WEST: {
                    if (!((double)hitx > 0.2) || !((double)hitx < 0.8) || !((double)hitz < 0.5)) break;
                    returnValue = true;
                    break;
                }
                case NORTH: {
                    if (!((double)hitz > 0.2) || !((double)hitz < 0.8) || !((double)hitx > 0.5)) break;
                    returnValue = true;
                    break;
                }
                case EAST: {
                    if (!((double)hitx > 0.2) || !((double)hitx < 0.8) || !((double)hitz > 0.5)) break;
                    returnValue = true;
                    break;
                }
            }
        }
        return returnValue;
    }

    public boolean isLeftBookStack(float hitx, float hitz, EnumFacing face, EnumFacing angle) {
        boolean returnValue = false;
        if (face == EnumFacing.UP) {
            switch (angle) {
                case SOUTH: {
                    if (!((double)hitx > 0.5) || !((double)hitz < 0.5)) break;
                    returnValue = true;
                    break;
                }
                case WEST: {
                    if (!((double)hitx > 0.5) || !((double)hitz > 0.5)) break;
                    returnValue = true;
                    break;
                }
                case NORTH: {
                    if (!((double)hitx < 0.5) || !((double)hitz > 0.5)) break;
                    returnValue = true;
                    break;
                }
                case EAST: {
                    if (!((double)hitx < 0.5) || !((double)hitz < 0.5)) break;
                    returnValue = true;
                    break;
                }
            }
        }
        return returnValue;
    }

    public boolean isRightBookStack(float hitx, float hitz, EnumFacing face, EnumFacing angle) {
        boolean returnValue = false;
        if (face == EnumFacing.UP) {
            switch (angle) {
                case SOUTH: {
                    if (!((double)hitx > 0.5) || !((double)hitz > 0.5)) break;
                    returnValue = true;
                    break;
                }
                case WEST: {
                    if (!((double)hitx < 0.5) || !((double)hitz > 0.5)) break;
                    returnValue = true;
                    break;
                }
                case NORTH: {
                    if (!((double)hitx < 0.5) || !((double)hitz < 0.5)) break;
                    returnValue = true;
                    break;
                }
                case EAST: {
                    if (!((double)hitx > 0.5) || !((double)hitz < 0.5)) break;
                    returnValue = true;
                    break;
                }
            }
        }
        return returnValue;
    }

    @Override
    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return world.func_175623_d(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
    }

    @Override
    public TextureState addAdditionTextureStateInformation(BiblioTileEntity tile, TextureState state) {
        ItemStack carpet = tile.func_70301_a(9);
        if (carpet != ItemStack.field_190927_a) {
            state.setColorOne(EnumColor.getColorFromCarpetOrWool(carpet));
        }
        return state;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityDesk currDesk;
        this.dropItems(world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityDesk && (currDesk = (TileEntityDesk)tile) != null) {
            EnumFacing angle = currDesk.getAngle();
            switch (currDesk.getSingleLeftRightCenter()) {
                case LEFT: {
                    this.adjustRightDesk(world, currDesk.func_174877_v(), angle);
                    break;
                }
                case RIGHT: {
                    this.adjustLeftDesk(world, currDesk.func_174877_v(), angle);
                    break;
                }
                case CENTER: {
                    this.adjustLeftDesk(world, currDesk.func_174877_v(), angle);
                    this.adjustRightDesk(world, currDesk.func_174877_v(), angle);
                    break;
                }
            }
        }
        super.func_180663_b(world, pos, state);
    }

    private void adjustLeftDesk(World world, BlockPos pos, EnumFacing angle) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (angle) {
            case SOUTH: {
                --z;
                break;
            }
            case WEST: {
                ++x;
                break;
            }
            case NORTH: {
                ++z;
                break;
            }
            case EAST: {
                --x;
                break;
            }
        }
        TileEntityDesk desk = (TileEntityDesk)world.func_175625_s(new BlockPos(x, y, z));
        if (desk != null) {
            switch (desk.getSingleLeftRightCenter()) {
                case LEFT: {
                    desk.setSingleLeftRightCenter(EnumRelativeLocation.SINGLE);
                    break;
                }
                case CENTER: {
                    desk.setSingleLeftRightCenter(EnumRelativeLocation.RIGHT);
                    break;
                }
            }
        }
    }

    private void adjustRightDesk(World world, BlockPos pos, EnumFacing angle) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (angle) {
            case SOUTH: {
                ++z;
                break;
            }
            case WEST: {
                --x;
                break;
            }
            case NORTH: {
                --z;
                break;
            }
            case EAST: {
                ++x;
                break;
            }
        }
        TileEntityDesk desk = (TileEntityDesk)world.func_175625_s(new BlockPos(x, y, z));
        if (desk != null) {
            switch (desk.getSingleLeftRightCenter()) {
                case RIGHT: {
                    desk.setSingleLeftRightCenter(EnumRelativeLocation.SINGLE);
                    break;
                }
                case CENTER: {
                    desk.setSingleLeftRightCenter(EnumRelativeLocation.LEFT);
                    break;
                }
            }
        }
    }
}

