/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net.cache;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.net.cache.BuildCraftObjectCaches;
import buildcraft.lib.net.cache.MessageObjectCacheRequest;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class NetworkedObjectCache<T> {
    static final boolean DEBUG_LOG = BCDebugging.shouldDebugLog("lib.net.cache");
    static final boolean DEBUG_CPLX = BCDebugging.shouldDebugComplex("lib.net.cache");
    protected final T defaultObject;
    private final Int2ObjectMap<T> serverIdToObject = new Int2ObjectOpenHashMap();
    private final Object2IntMap<T> serverObjectToId = this.createObject2IntMap();
    private int serverCurrentId = 0;
    private final Int2ObjectMap<Link> clientObjects = new Int2ObjectOpenHashMap();
    private final Queue<Link> clientUnknowns = new LinkedList<Link>();
    private final ServerView serverView = new ServerView();
    private final ClientView clientView = new ClientView();

    public NetworkedObjectCache(T defaultObject) {
        this.defaultObject = defaultObject;
        this.serverObjectToId.defaultReturnValue(-1);
    }

    protected abstract Object2IntMap<T> createObject2IntMap();

    public ServerView server() {
        MinecraftServer server;
        if (DEBUG_LOG && !(server = FMLCommonHandler.instance().getMinecraftServerInstance()).func_152345_ab()) {
            throw new IllegalStateException("");
        }
        return this.serverView;
    }

    public ClientView client() {
        if (DEBUG_LOG && !Minecraft.func_71410_x().func_152345_ab()) {
            throw new IllegalStateException("");
        }
        return this.clientView;
    }

    protected abstract void writeObject(T var1, PacketBufferBC var2);

    protected abstract T readObject(PacketBufferBC var1) throws IOException;

    protected String getCacheName() {
        return this.getClass().getSimpleName();
    }

    private int serverStore(T object) {
        Integer current = (Integer)this.serverObjectToId.get(object);
        if (current == null) {
            int id = this.serverCurrentId++;
            T copy = this.copyOf(object);
            this.serverObjectToId.put(copy, id);
            this.serverIdToObject.put(id, copy);
            if (DEBUG_CPLX) {
                String toString;
                if (copy instanceof FluidStack) {
                    FluidStack fluid = (FluidStack)copy;
                    toString = fluid.getUnlocalizedName();
                } else {
                    toString = copy.toString();
                }
                BCLog.logger.info("[lib.net.cache] The cache " + this.getNameAndId() + " stored #" + id + " as " + toString);
            }
            return id;
        }
        return current;
    }

    protected abstract T copyOf(T var1);

    private int serverGetId(T object) {
        return this.serverObjectToId.getInt(object);
    }

    private Link clientRetrieve(int id) {
        Link current = (Link)this.clientObjects.get(id);
        if (current == null) {
            if (DEBUG_CPLX) {
                BCLog.logger.info("[lib.net.cache] The cache " + this.getNameAndId() + " tried to retrieve #" + id + " for the first time");
            }
            current = new Link(id);
            this.clientUnknowns.add(current);
            this.clientObjects.put(id, (Object)current);
        }
        return current;
    }

    void writeObjectServer(int id, PacketBufferBC buffer) {
        Object obj = this.serverIdToObject.get(id);
        this.writeObject(obj, buffer);
    }

    void readObjectClient(int id, PacketBufferBC buffer) throws IOException {
        Link link = this.clientRetrieve(id);
        link.actual = this.readObject(buffer);
        if (DEBUG_CPLX) {
            String toString;
            Object read = link.actual;
            if (read instanceof FluidStack) {
                FluidStack fluid = (FluidStack)read;
                toString = fluid.getUnlocalizedName();
            } else {
                toString = read.toString();
            }
            BCLog.logger.info("[lib.net.cache] The cache " + this.getNameAndId() + " just received #" + id + " as " + toString);
        }
    }

    final String getNameAndId() {
        return "(" + BuildCraftObjectCaches.CACHES.indexOf(this) + " = " + this.getCacheName() + ")";
    }

    void onClientWorldTick() {
        int[] ids = new int[this.clientUnknowns.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this.clientUnknowns.remove().id;
        }
        if (ids.length > 0) {
            if (DEBUG_CPLX) {
                BCLog.logger.info("[lib.net.cache] The cache " + this.getNameAndId() + " requests ID's " + Arrays.toString(ids));
            }
            MessageManager.sendToServer(new MessageObjectCacheRequest(this, ids));
        }
    }

    void onClientJoinServer() {
        this.clientObjects.clear();
        this.clientUnknowns.clear();
    }

    public class Link
    implements Supplier<T> {
        T actual;
        final int id;

        Link(int id) {
            this.id = id;
        }

        @Override
        public T get() {
            return this.actual == null ? NetworkedObjectCache.this.defaultObject : this.actual;
        }

        public boolean hasBeenReceived() {
            return this.actual != null;
        }
    }

    public class ClientView {
        private ClientView() {
        }

        public Link retrieve(int id) {
            return NetworkedObjectCache.this.clientRetrieve(id);
        }
    }

    public class ServerView {
        private ServerView() {
        }

        public int store(T value) {
            return NetworkedObjectCache.this.serverStore(value);
        }

        public int getId(T value) {
            return NetworkedObjectCache.this.serverGetId(value);
        }
    }
}

