/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.miniserv;

import java.nio.ByteBuffer;

public final class PacketWriter {
    private final byte[] sizeBytes = new byte[4];
    private byte[] packet;
    private int pos = 0;
    private boolean needToWriteSize = true;

    public final boolean writeTo(ByteBuffer bb) {
        if (this.packet == null) {
            return true;
        }
        if (this.needToWriteSize) {
            if (this.writeByteArray(bb, this.sizeBytes)) {
                this.needToWriteSize = false;
                this.pos = 0;
            } else {
                return false;
            }
        }
        if (this.writeByteArray(bb, this.packet)) {
            this.packet = null;
            return true;
        }
        return false;
    }

    private boolean writeByteArray(ByteBuffer dst, byte[] src) {
        int remaining = src.length - this.pos;
        int written = dst.remaining() >= remaining ? remaining : dst.remaining();
        dst.put(src, this.pos, written);
        this.pos += written;
        return this.pos >= src.length;
    }

    public final void reset(byte[] pkt) {
        int len = pkt.length + 4;
        this.sizeBytes[0] = (byte)(len >> 24 & 0xFF);
        this.sizeBytes[1] = (byte)(len >> 16 & 0xFF);
        this.sizeBytes[2] = (byte)(len >> 8 & 0xFF);
        this.sizeBytes[3] = (byte)(len & 0xFF);
        this.packet = pkt;
        this.pos = 0;
        this.needToWriteSize = true;
    }

    public final void clear() {
        this.packet = null;
        this.pos = 0;
        this.needToWriteSize = true;
    }
}

