/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockPeripheral;
import net.montoyo.wd.core.DefaultPeripheral;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.net.Message;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;

@Message(messageId=2, side=Side.SERVER)
public class SMessageScreenCtrl
implements IMessage,
Runnable {
    public static final int CTRL_SET_URL = 0;
    public static final int CTRL_SHUT_DOWN = 1;
    public static final int CTRL_ADD_FRIEND = 2;
    public static final int CTRL_REMOVE_FRIEND = 3;
    public static final int CTRL_SET_RIGHTS = 4;
    public static final int CTRL_SET_RESOLUTION = 5;
    public static final int CTRL_TYPE = 6;
    public static final int CTRL_REMOVE_UPGRADE = 7;
    public static final int CTRL_LASER_DOWN = 8;
    public static final int CTRL_LASER_MOVE = 9;
    public static final int CTRL_LASER_UP = 10;
    public static final int CTRL_JS_REQUEST = 11;
    public static final int CTRL_SET_ROTATION = 12;
    public static final int CTRL_SET_URL_REMOTE = 13;
    public static final int CTRL_SET_AUTO_VOL = 14;
    private int ctrl;
    private int dim;
    private Vector3i pos;
    private BlockSide side;
    private String url;
    private NameUUIDPair friend;
    private EntityPlayerMP player;
    private int friendRights;
    private int otherRights;
    private Vector2i vec2i;
    private String text;
    private BlockPos soundPos;
    private ItemStack toRemove;
    private int jsReqID;
    private JSServerRequest jsReqType;
    private Object[] jsReqData;
    private Rotation rotation;
    private Vector3i remoteLoc;
    private boolean autoVol;

    public SMessageScreenCtrl() {
    }

    public static SMessageScreenCtrl setURL(TileEntityScreen tes, BlockSide side, String url, Vector3i remoteLocation) {
        SMessageScreenCtrl ret = new SMessageScreenCtrl();
        ret.ctrl = remoteLocation == null ? 0 : 13;
        ret.dim = tes.func_145831_w().field_73011_w.getDimension();
        ret.pos = new Vector3i(tes.func_174877_v());
        ret.side = side;
        ret.url = url;
        if (remoteLocation != null) {
            ret.remoteLoc = remoteLocation;
        }
        return ret;
    }

    public SMessageScreenCtrl(TileEntityScreen tes, BlockSide side, NameUUIDPair friend, boolean del) {
        this.ctrl = del ? 3 : 2;
        this.dim = tes.func_145831_w().field_73011_w.getDimension();
        this.pos = new Vector3i(tes.func_174877_v());
        this.side = side;
        this.friend = friend;
    }

    public SMessageScreenCtrl(TileEntityScreen tes, BlockSide side, int fr, int or) {
        this.ctrl = 4;
        this.dim = tes.func_145831_w().field_73011_w.getDimension();
        this.pos = new Vector3i(tes.func_174877_v());
        this.side = side;
        this.friendRights = fr;
        this.otherRights = or;
    }

    public SMessageScreenCtrl(TileEntityScreen tes, BlockSide side, ItemStack toRem) {
        this.ctrl = 7;
        this.dim = tes.func_145831_w().field_73011_w.getDimension();
        this.pos = new Vector3i(tes.func_174877_v());
        this.side = side;
        this.toRemove = toRem;
    }

    public SMessageScreenCtrl(TileEntityScreen tes, BlockSide side, Rotation rot) {
        this.ctrl = 12;
        this.dim = tes.func_145831_w().field_73011_w.getDimension();
        this.pos = new Vector3i(tes.func_174877_v());
        this.side = side;
        this.rotation = rot;
    }

    public static SMessageScreenCtrl type(TileEntityScreen tes, BlockSide side, String text, BlockPos soundPos) {
        SMessageScreenCtrl ret = new SMessageScreenCtrl();
        ret.ctrl = 6;
        ret.pos = new Vector3i(tes.func_174877_v());
        ret.dim = tes.func_145831_w().field_73011_w.getDimension();
        ret.side = side;
        ret.text = text;
        ret.soundPos = soundPos;
        return ret;
    }

    public static SMessageScreenCtrl vec2(TileEntityScreen tes, BlockSide side, int ctrl, Vector2i vec) {
        if (!SMessageScreenCtrl.isVec2Ctrl(ctrl)) {
            throw new RuntimeException("Called SMessageScreenCtrl.vec2() with non-vec2 control message " + ctrl);
        }
        SMessageScreenCtrl ret = new SMessageScreenCtrl();
        ret.ctrl = ctrl;
        ret.pos = new Vector3i(tes.func_174877_v());
        ret.dim = tes.func_145831_w().field_73011_w.getDimension();
        ret.side = side;
        ret.vec2i = vec;
        return ret;
    }

    public static SMessageScreenCtrl laserUp(TileEntityScreen tes, BlockSide side) {
        SMessageScreenCtrl ret = new SMessageScreenCtrl();
        ret.ctrl = 10;
        ret.pos = new Vector3i(tes.func_174877_v());
        ret.dim = tes.func_145831_w().field_73011_w.getDimension();
        ret.side = side;
        return ret;
    }

    public static SMessageScreenCtrl jsRequest(TileEntityScreen tes, BlockSide side, int reqId, JSServerRequest reqType, Object ... data) {
        SMessageScreenCtrl ret = new SMessageScreenCtrl();
        ret.ctrl = 11;
        ret.pos = new Vector3i(tes.func_174877_v());
        ret.dim = tes.func_145831_w().field_73011_w.getDimension();
        ret.side = side;
        ret.jsReqID = reqId;
        ret.jsReqType = reqType;
        ret.jsReqData = data;
        return ret;
    }

    public static SMessageScreenCtrl autoVol(TileEntityScreen tes, BlockSide side, boolean av) {
        SMessageScreenCtrl ret = new SMessageScreenCtrl();
        ret.ctrl = 14;
        ret.pos = new Vector3i(tes.func_174877_v());
        ret.dim = tes.func_145831_w().field_73011_w.getDimension();
        ret.side = side;
        ret.autoVol = av;
        return ret;
    }

    private static boolean isVec2Ctrl(int msg) {
        return msg == 5 || msg == 8 || msg == 9;
    }

    public void fromBytes(ByteBuf buf) {
        this.ctrl = buf.readByte();
        this.dim = buf.readInt();
        this.pos = new Vector3i(buf);
        this.side = BlockSide.fromInt(buf.readByte());
        if (this.ctrl == 0) {
            this.url = ByteBufUtils.readUTF8String((ByteBuf)buf);
        } else if (this.ctrl == 2 || this.ctrl == 3) {
            this.friend = new NameUUIDPair(buf);
        } else if (this.ctrl == 4) {
            this.friendRights = buf.readByte();
            this.otherRights = buf.readByte();
        } else if (SMessageScreenCtrl.isVec2Ctrl(this.ctrl)) {
            this.vec2i = new Vector2i(buf);
        } else if (this.ctrl == 6) {
            this.text = ByteBufUtils.readUTF8String((ByteBuf)buf);
            int sx = buf.readInt();
            int sy = buf.readInt();
            int sz = buf.readInt();
            this.soundPos = new BlockPos(sx, sy, sz);
        } else if (this.ctrl == 7) {
            this.toRemove = ByteBufUtils.readItemStack((ByteBuf)buf);
        } else if (this.ctrl == 11) {
            this.jsReqID = buf.readInt();
            this.jsReqType = JSServerRequest.fromID(buf.readByte());
            if (this.jsReqType != null) {
                this.jsReqData = this.jsReqType.deserialize(buf);
            }
        } else if (this.ctrl == 12) {
            this.rotation = Rotation.values()[buf.readByte() & 3];
        } else if (this.ctrl == 13) {
            this.url = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.remoteLoc = new Vector3i(buf);
        } else if (this.ctrl == 14) {
            this.autoVol = buf.readBoolean();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.ctrl);
        buf.writeInt(this.dim);
        this.pos.writeTo(buf);
        buf.writeByte(this.side.ordinal());
        if (this.ctrl == 0) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.url);
        } else if (this.ctrl == 2 || this.ctrl == 3) {
            this.friend.writeTo(buf);
        } else if (this.ctrl == 4) {
            buf.writeByte(this.friendRights);
            buf.writeByte(this.otherRights);
        } else if (SMessageScreenCtrl.isVec2Ctrl(this.ctrl)) {
            this.vec2i.writeTo(buf);
        } else if (this.ctrl == 6) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
            buf.writeInt(this.soundPos.func_177958_n());
            buf.writeInt(this.soundPos.func_177956_o());
            buf.writeInt(this.soundPos.func_177952_p());
        } else if (this.ctrl == 7) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.toRemove);
        } else if (this.ctrl == 11) {
            buf.writeInt(this.jsReqID);
            buf.writeByte(this.jsReqType.ordinal());
            if (!this.jsReqType.serialize(buf, this.jsReqData)) {
                throw new RuntimeException("Could not serialize CTRL_JS_REQUEST " + (Object)((Object)this.jsReqType));
            }
        } else if (this.ctrl == 12) {
            buf.writeByte(this.rotation.ordinal());
        } else if (this.ctrl == 13) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.url);
            this.remoteLoc.writeTo(buf);
        } else if (this.ctrl == 14) {
            buf.writeBoolean(this.autoVol);
        }
    }

    @Override
    public void run() {
        if (this.side == null) {
            Log.warning("Caught invalid packet from %s (UUID %s) referencing an invalid block side", this.player.func_70005_c_(), this.player.func_146103_bH().getId().toString());
            return;
        }
        try {
            this.runUnsafe();
        }
        catch (MissingPermissionException e) {
            Log.errorEx("I have reasons to believe %s (UUID %s) is a hacker, but don't take my word for it...", e, e.getPlayer().func_70005_c_(), e.getPlayer().func_146103_bH().getId().toString());
        }
    }

    private void checkPermission(TileEntityScreen scr, int right) throws MissingPermissionException {
        int prights = scr.getScreen(this.side).rightsFor((EntityPlayer)this.player);
        if ((prights & right) == 0) {
            throw new MissingPermissionException(right, this.player);
        }
    }

    private void runUnsafe() throws MissingPermissionException {
        TileEntity te;
        World world = this.player.field_70170_p;
        BlockPos bp = this.pos.toBlock();
        if (world.field_73011_w.getDimension() != this.dim) {
            return;
        }
        if (this.ctrl == 13) {
            double reachDist = this.player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
            BlockPos blockPos = this.remoteLoc.toBlock();
            if (this.player.func_174818_b(blockPos) > reachDist * reachDist) {
                return;
            }
            IBlockState bs = world.func_180495_p(blockPos);
            if (bs.func_177230_c() != WebDisplays.INSTANCE.blockPeripheral || bs.func_177229_b(BlockPeripheral.type) != DefaultPeripheral.REMOTE_CONTROLLER) {
                return;
            }
        } else if (this.player.func_174818_b(bp) > 16384.0) {
            return;
        }
        if ((te = world.func_175625_s(bp)) == null || !(te instanceof TileEntityScreen)) {
            Log.error("TileEntity at %s is not a screen; can't control it!", this.pos.toString());
            return;
        }
        TileEntityScreen tes = (TileEntityScreen)te;
        if (this.ctrl == 0 || this.ctrl == 13) {
            this.checkPermission(tes, 1);
            tes.setScreenURL(this.side, this.url);
        } else if (this.ctrl != 1) {
            if (this.ctrl == 2) {
                this.checkPermission(tes, 4);
                tes.addFriend(this.player, this.side, this.friend);
            } else if (this.ctrl == 3) {
                this.checkPermission(tes, 4);
                tes.removeFriend(this.player, this.side, this.friend);
            } else if (this.ctrl == 4) {
                TileEntityScreen.Screen scr = tes.getScreen(this.side);
                if (scr != null) {
                    int or;
                    int fr = scr.owner.uuid.equals(this.player.func_146103_bH().getId()) ? this.friendRights : scr.friendRights;
                    int n = or = (scr.rightsFor((EntityPlayer)this.player) & 8) == 0 ? scr.otherRights : this.otherRights;
                    if (scr.friendRights != fr || scr.otherRights != or) {
                        tes.setRights(this.player, this.side, fr, or);
                    }
                }
            } else if (this.ctrl == 5) {
                this.checkPermission(tes, 32);
                tes.setResolution(this.side, this.vec2i);
            } else if (this.ctrl == 6) {
                this.checkPermission(tes, 2);
                tes.type(this.side, this.text, this.soundPos);
            } else if (this.ctrl == 7) {
                this.checkPermission(tes, 16);
                tes.removeUpgrade(this.side, this.toRemove, (EntityPlayer)this.player);
            } else if (this.ctrl == 8 || this.ctrl == 9) {
                tes.laserDownMove(this.side, (EntityPlayer)this.player, this.vec2i, this.ctrl == 8);
            } else if (this.ctrl == 10) {
                tes.laserUp(this.side, (EntityPlayer)this.player);
            } else if (this.ctrl == 11) {
                if (this.jsReqType == null || this.jsReqData == null) {
                    Log.warning("Caught invalid JS request from player %s (UUID %s)", this.player.func_70005_c_(), this.player.func_146103_bH().getId().toString());
                } else {
                    tes.handleJSRequest(this.player, this.side, this.jsReqID, this.jsReqType, this.jsReqData);
                }
            } else if (this.ctrl == 12) {
                this.checkPermission(tes, 32);
                tes.setRotation(this.side, this.rotation);
            } else if (this.ctrl == 14) {
                this.checkPermission(tes, 16);
                tes.setAutoVolume(this.side, this.autoVol);
            } else {
                Log.warning("Caught SMessageScreenCtrl with invalid control ID %d from player %s (UUID %s)", this.ctrl, this.player.func_70005_c_(), this.player.func_146103_bH().getId().toString());
            }
        }
    }

    public static class Handler
    implements IMessageHandler<SMessageScreenCtrl, IMessage> {
        public IMessage onMessage(SMessageScreenCtrl message, MessageContext ctx) {
            message.player = ctx.getServerHandler().field_147369_b;
            ((WorldServer)((SMessageScreenCtrl)message).player.field_70170_p).func_152344_a((Runnable)message);
            return null;
        }
    }
}

