/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities;

import net.montoyo.wd.utilities.Vector3i;

public final class Vector3f {
    public float x;
    public float y;
    public float z;

    public Vector3f() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vector3f(float val) {
        this.x = val;
        this.y = val;
        this.z = val;
    }

    public Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3f clone() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public int hashCode() {
        return ((37 + Float.floatToRawIntBits(this.x)) * 31 + Float.floatToRawIntBits(this.y)) * 43 + Float.floatToRawIntBits(this.z);
    }

    public boolean equals(Object o) {
        if (o instanceof Vector3f) {
            Vector3f src = (Vector3f)o;
            return src.x == this.x && src.y == this.y && src.z == this.z;
        }
        return false;
    }

    public Vector3f add(Vector3f src) {
        this.x += src.x;
        this.y += src.y;
        this.z += src.z;
        return this;
    }

    public Vector3f addMul(Vector3f src, float m) {
        this.x += src.x * m;
        this.y += src.y * m;
        this.z += src.z * m;
        return this;
    }

    public Vector3f add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3f add(float xyz) {
        this.x += xyz;
        this.y += xyz;
        this.z += xyz;
        return this;
    }

    public Vector3f sub(Vector3f src) {
        this.x -= src.x;
        this.y -= src.y;
        this.z -= src.z;
        return this;
    }

    public Vector3f sub(float x, float y, float z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3f sub(float xyz) {
        this.x -= xyz;
        this.y -= xyz;
        this.z -= xyz;
        return this;
    }

    public Vector3f neg() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3f mul(float val) {
        this.x *= val;
        this.y *= val;
        this.z *= val;
        return this;
    }

    public Vector3f div(float val) {
        this.x /= val;
        this.y /= val;
        this.z /= val;
        return this;
    }

    public Vector3f set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3f set(float xyz) {
        this.x = xyz;
        this.y = xyz;
        this.z = xyz;
        return this;
    }

    public float dot(Vector3f vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public Vector3f set(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        return this;
    }

    public Vector3f set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3f set(Vector3f vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        return this;
    }

    public Vector3f set(Vector3i vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        return this;
    }
}

