/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.client;

import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.invpanel.client.ItemEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractItemEntryFilter {
    @Nonnull
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\s+");

    public abstract boolean matches(@Nonnull ItemEntry var1);

    @Nullable
    public static AbstractItemEntryFilter parse(@Nonnull String filter, @Nonnull Locale locale, @Nullable IItemFilter filterCard) {
        String[] parts;
        ArrayList<AbstractItemEntryFilter> list = new ArrayList<AbstractItemEntryFilter>();
        if (filterCard != null) {
            list.add(new CardEntryFilter(filterCard));
        }
        for (String part : parts = SPLIT_PATTERN.split(filter)) {
            if (part.startsWith("@")) {
                if ((part = part.substring(1)).isEmpty()) continue;
                list.add(new ModEntryFilter(part, locale));
                continue;
            }
            if (part.isEmpty()) continue;
            list.add(new NameEntryFilter(part, locale));
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (AbstractItemEntryFilter)list.get(0);
        }
        return new AndEntryFilter(list.toArray(new AbstractItemEntryFilter[list.size()]));
    }

    static class CardEntryFilter
    extends AbstractItemEntryFilter {
        @Nonnull
        final IItemFilter filter;

        CardEntryFilter(@Nonnull IItemFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean matches(@Nonnull ItemEntry entry) {
            return this.filter.doesItemPassFilter(null, entry.makeItemStack());
        }
    }

    static class NameEntryFilter
    extends AbstractItemEntryFilter {
        @Nonnull
        final String text;
        @Nonnull
        final Locale locale;

        NameEntryFilter(@Nonnull String text, @Nonnull Locale locale) {
            this.text = text.toLowerCase(locale);
            this.locale = locale;
        }

        @Override
        public boolean matches(@Nonnull ItemEntry entry) {
            return entry.getLowercaseUnlocName(this.locale).contains(this.text);
        }

        public String toString() {
            return this.text;
        }
    }

    static class ModEntryFilter
    extends AbstractItemEntryFilter {
        @Nonnull
        final String text;
        @Nonnull
        final Locale locale;

        ModEntryFilter(@Nonnull String text, @Nonnull Locale locale) {
            this.text = text.toLowerCase(locale);
            this.locale = locale;
        }

        @Override
        public boolean matches(@Nonnull ItemEntry entry) {
            return entry.getModId().toLowerCase(this.locale).contains(this.text);
        }

        @Nonnull
        public String toString() {
            return "@" + this.text;
        }
    }

    static class AndEntryFilter
    extends AbstractItemEntryFilter {
        @Nonnull
        final AbstractItemEntryFilter[] list;

        AndEntryFilter(@Nonnull AbstractItemEntryFilter[] list) {
            this.list = list;
        }

        @Override
        public boolean matches(@Nonnull ItemEntry entry) {
            for (AbstractItemEntryFilter f : this.list) {
                if (f.matches(entry)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return Arrays.deepToString(this.list);
        }
    }
}

