/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.integration;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlock;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

@WailaPlugin(value="tesseract")
public class TesseractWailaPlugin
implements IWailaDataProvider,
IWailaPlugin {
    public void register(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, TesseractBlock.class);
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity entity = accessor.getTileEntity();
        if (entity instanceof TesseractBlockEntity) {
            TesseractBlockEntity tesseract = (TesseractBlockEntity)entity;
            tooltip.add(TextComponents.translation((String)"tesseract.tesseract.highlight.channels").format());
            tooltip.add(TesseractWailaPlugin.formatChannelInfo(EnumChannelType.ITEMS, tesseract.getChannelId(EnumChannelType.ITEMS)));
            tooltip.add(TesseractWailaPlugin.formatChannelInfo(EnumChannelType.ENERGY, tesseract.getChannelId(EnumChannelType.ENERGY)));
            tooltip.add(TesseractWailaPlugin.formatChannelInfo(EnumChannelType.FLUID, tesseract.getChannelId(EnumChannelType.FLUID)));
            if (tesseract.isBlockedByRedstone()) {
                tooltip.add(TextComponents.translation((String)"tesseract.tesseract.highlight.redstone_blocked").color(TextFormatting.RED).format());
            }
        }
        return tooltip;
    }

    private static String formatChannelInfo(EnumChannelType type, int channelId) {
        Channel channel = TesseractChannelManager.CLIENT.getChannelById(type, channelId);
        ITextComponent channelType = TextComponents.fromTextComponent((ITextComponent)type.getTranslation()).color(TextFormatting.GOLD).get();
        ITextComponent separator = TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info.separator").get();
        ITextComponent channelName = channel == null ? TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info.inactive").color(TextFormatting.DARK_GRAY).italic().get() : TextComponents.string((String)channel.name).get();
        return TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info", (Object[])new Object[]{channelType, separator, channelName}).format();
    }
}

