/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.recipes;

import cassiokf.industrialrenewal.IndustrialRenewal;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LatheRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public static final List<LatheRecipe> LATHE_RECIPES = new CopyOnWriteArrayList<LatheRecipe>();
    public static final Map<Item, LatheRecipe> CACHED_RECIPES = new HashMap<Item, LatheRecipe>();
    private final List<ItemStack> input;
    private final ItemStack output;
    private final int processTime;

    public LatheRecipe(List<ItemStack> input, ItemStack output, int processTime) {
        this.input = input;
        this.output = output;
        this.processTime = processTime;
        IndustrialRenewal.LOGGER.info("Loaded " + this.output.func_82833_r() + " Lathe Recipe");
    }

    public static void populateLatheRecipes() {
        int recipesAmount = 0;
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            if (!(recipe instanceof LatheRecipe)) continue;
            LATHE_RECIPES.add((LatheRecipe)recipe);
            ++recipesAmount;
            for (ItemStack item : ((LatheRecipe)recipe).input) {
                CACHED_RECIPES.put(item.func_77973_b(), (LatheRecipe)recipe);
            }
        }
        IndustrialRenewal.LOGGER.info(TextFormatting.GREEN + "Industrial Renewal" + " Registered " + recipesAmount + " Recipes for Lathe Machine via json");
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.input.equals(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            List<ItemStack> input = this.getOredictItemStack(context, json, "input");
            ItemStack result = this.getOredictItemStack(context, json, "result").get(0);
            int processTime = JsonUtils.func_151203_m((JsonObject)json, (String)"process_time");
            return new LatheRecipe(input, result, processTime);
        }

        private List<ItemStack> getOredictItemStack(JsonContext context, JsonObject json, String memberName) {
            JsonObject jsonObject = JsonUtils.func_152754_s((JsonObject)json, (String)memberName);
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            if (jsonObject.has("ore")) {
                NonNullList list2;
                String ore = jsonObject.get("ore").getAsString();
                if (OreDictionary.doesOreNameExist((String)ore) && !(list2 = OreDictionary.getOres((String)ore)).isEmpty()) {
                    for (ItemStack stack : list2) {
                        list.add(stack.func_77946_l());
                    }
                    if (jsonObject.has("count")) {
                        int count = jsonObject.get("count").getAsInt();
                        for (ItemStack stack : list) {
                            stack.func_190920_e(count);
                        }
                    }
                    return list;
                }
                throw new JsonSyntaxException("Unknown oreDict item '" + ore + "'");
            }
            list.add(CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)memberName), (JsonContext)context));
            return list;
        }
    }
}

