/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client.flight;

import javax.annotation.Nullable;
import me.paulf.wings.client.flight.FlightView;
import me.paulf.wings.client.flight.FlightViewDefault;
import me.paulf.wings.client.flight.FlightViewStatic;
import me.paulf.wings.server.flight.AttachFlightCapabilityEvent;
import me.paulf.wings.util.CapabilityHolder;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="wings", value={Side.CLIENT})
public final class FlightViews {
    private static final CapabilityHolder<EntityLivingBase, FlightView, CapabilityHolder.State<EntityLivingBase, FlightView>> HOLDER = CapabilityHolder.create();

    private FlightViews() {
    }

    public static boolean has(EntityLivingBase player) {
        return HOLDER.state().has(player, null);
    }

    @Nullable
    public static FlightView get(EntityLivingBase player) {
        return HOLDER.state().get(player, null);
    }

    @CapabilityInject(value=FlightView.class)
    static void inject(Capability<FlightView> capability) {
        HOLDER.inject(capability);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachFlightCapabilityEvent event) {
        Entity entity = event.getObject();
        if (entity instanceof AbstractClientPlayer) {
            event.addCapability(new ResourceLocation("wings", "flight_view"), HOLDER.state().providerBuilder(new FlightViewDefault((EntityPlayer)entity, event.getInstance())).build());
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof EntityLivingBase && !(entity instanceof AbstractClientPlayer)) {
            event.addCapability(new ResourceLocation("wings", "flight_view"), HOLDER.state().providerBuilder(new FlightViewStatic((EntityLivingBase)entity)).build());
        }
    }
}

