/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.container;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import com.the9grounds.aeadditions.container.IFluidSelectorContainer;
import com.the9grounds.aeadditions.container.StorageType;
import com.the9grounds.aeadditions.container.slot.SlotOutput;
import com.the9grounds.aeadditions.container.slot.SlotRespective;
import com.the9grounds.aeadditions.network.packet.part.PacketTerminalSelectFluidServer;
import com.the9grounds.aeadditions.network.packet.part.PacketTerminalUpdateFluid;
import com.the9grounds.aeadditions.part.gas.PartGasTerminal;
import com.the9grounds.aeadditions.util.NetworkUtil;
import com.the9grounds.aeadditions.util.PermissionUtil;
import com.the9grounds.aeadditions.util.StorageChannels;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class ContainerTerminal
extends Container
implements IMEMonitorHandlerReceiver<IAEFluidStack>,
IFluidSelectorContainer {
    private PartGasTerminal terminal;
    private IMEMonitor<IAEFluidStack> monitor;
    private IItemList<IAEFluidStack> fluidStackList;
    private Fluid selectedFluid;
    private EntityPlayer player;
    private StorageType type;

    public ContainerTerminal(PartGasTerminal terminal, EntityPlayer player, StorageType type) {
        this.terminal = terminal;
        this.player = player;
        this.type = type;
        this.fluidStackList = StorageChannels.FLUID.createList();
        if (!this.player.field_70170_p.field_72995_K) {
            this.monitor = type == StorageType.GAS ? this.terminal.getGridBlock().getFluidGasMonitor() : this.terminal.getGridBlock().getFluidMonitor();
            if (this.monitor != null) {
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                this.fluidStackList = this.monitor.getStorageList();
            }
            this.terminal.addContainer(this);
        }
        this.func_75146_a(new SlotRespective(this.terminal.getInventory(), 0, 8, 92));
        this.func_75146_a(new SlotOutput(this.terminal.getInventory(), 1, 26, 92));
        this.bindPlayerInventory(this.player.field_71071_by);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, i * 18 + 122));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 180));
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        if (this.terminal == null) {
            return false;
        }
        return this.terminal.isValid();
    }

    public void forceFluidUpdate() {
        if (this.monitor != null) {
            NetworkUtil.sendToPlayer(new PacketTerminalUpdateFluid((IItemList<IAEFluidStack>)this.monitor.getStorageList()), this.player);
        }
    }

    public IItemList<IAEFluidStack> getFluidStackList() {
        return this.fluidStackList;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public Fluid getSelectedFluid() {
        return this.selectedFluid;
    }

    public PartGasTerminal getTerminal() {
        return this.terminal;
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void func_75134_a(EntityPlayer entityPlayer) {
        super.func_75134_a(entityPlayer);
        if (!entityPlayer.field_70170_p.field_72995_K) {
            if (this.monitor != null) {
                this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
            }
            this.terminal.removeContainer(this);
        }
    }

    public void onListUpdate() {
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, IActionSource actionSource) {
        this.fluidStackList = ((IMEMonitor)monitor).getStorageList();
        NetworkUtil.sendToPlayer(new PacketTerminalUpdateFluid(this.fluidStackList), this.player);
    }

    public void receiveSelectedFluid(Fluid _selectedFluid) {
        this.selectedFluid = _selectedFluid;
    }

    @Override
    public void setSelectedFluid(Fluid fluid) {
        NetworkUtil.sendToServer(new PacketTerminalSelectFluidServer(fluid, this.terminal));
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack stack;
        ItemStack returnStack = null;
        boolean hasPermission = true;
        if (!(slotId != 0 && slotId != 1 || (stack = player.field_71071_by.func_70445_o()) == null || stack.func_190926_b() || this.type.isEmpty(stack) && PermissionUtil.hasPermission(player, SecurityPermissions.INJECT, this.getTerminal()) || this.type.isFilled(stack) && PermissionUtil.hasPermission(player, SecurityPermissions.EXTRACT, this.getTerminal()))) {
            ItemStack slotStack = ((Slot)this.field_75151_b.get(slotId)).func_75211_c();
            returnStack = slotStack == null || slotStack.func_190926_b() ? ItemStack.field_190927_a : slotStack.func_77946_l();
            hasPermission = false;
        }
        if (hasPermission) {
            returnStack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP p = (EntityPlayerMP)player;
            p.func_71120_a((Container)this);
        }
        return returnStack;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotnumber) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotnumber);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (this.terminal.getInventory().func_94041_b(0, itemstack1)) {
                if (slotnumber == 1 || slotnumber == 0 ? !this.func_75135_a(itemstack1, 2, 36, false) : !this.func_75135_a(itemstack1, 0, 1, false)) {
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_190916_E() == 0) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
            } else {
                return ItemStack.field_190927_a;
            }
        }
        return itemstack;
    }

    public void updateFluidList(IItemList<IAEFluidStack> fluidStacks) {
        this.fluidStackList = fluidStacks;
    }
}

