/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.part.gas;

import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.google.common.collect.ImmutableList;
import com.the9grounds.aeadditions.api.gas.IAEGasStack;
import com.the9grounds.aeadditions.api.gas.IGasStorageChannel;
import com.the9grounds.aeadditions.container.gas.ContainerGasEmitter;
import com.the9grounds.aeadditions.gridblock.ECBaseGridBlock;
import com.the9grounds.aeadditions.gui.gas.GuiGasEmitter;
import com.the9grounds.aeadditions.gui.widget.fluid.IFluidSlotListener;
import com.the9grounds.aeadditions.integration.mekanism.gas.AEGasStack;
import com.the9grounds.aeadditions.models.PartModels;
import com.the9grounds.aeadditions.network.packet.other.PacketFluidSlotUpdate;
import com.the9grounds.aeadditions.network.packet.part.PacketPartConfig;
import com.the9grounds.aeadditions.part.PartECBase;
import com.the9grounds.aeadditions.part.gas.PartGasLevelEmitter$WhenMappings;
import com.the9grounds.aeadditions.util.GasUtil;
import com.the9grounds.aeadditions.util.NetworkUtil;
import com.the9grounds.aeadditions.util.PermissionUtil;
import com.the9grounds.aeadditions.util.StorageChannels;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0016J\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0016J\u0014\u0010*\u001a\u0004\u0018\u00010+2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0014\u0010.\u001a\u0004\u0018\u00010+2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010/\u001a\u000200H\u0016J\u0006\u00101\u001a\u00020\bJ\b\u00102\u001a\u00020\u0006H\u0002J\b\u00103\u001a\u00020\u001dH\u0016J\b\u00104\u001a\u00020\u001dH\u0016J\u0018\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109J&\u0010:\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016JH\u0010?\u001a\u00020\u001b2\f\u0010@\u001a\b\u0012\u0002\b\u0003\u0018\u00010A2\f\u0010B\u001a\b\u0012\u0002\b\u0003\u0018\u00010C2\f\u0010D\u001a\b\u0012\u0002\b\u0003\u0018\u00010C2\b\u0010E\u001a\u0004\u0018\u00010F2\n\u0010G\u001a\u0006\u0012\u0002\b\u00030HH\u0016J \u0010I\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\u00062\u0006\u0010Q\u001a\u00020TH\u0016J$\u0010U\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020\u001d2\b\u0010W\u001a\u0004\u0018\u00010\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0018\u0010X\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010Y\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010Z\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0012\u0010[\u001a\u00020\u001b2\b\u0010\\\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010]\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010^\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020TH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lcom/the9grounds/aeadditions/part/gas/PartGasLevelEmitter;", "Lcom/the9grounds/aeadditions/part/PartECBase;", "Lappeng/api/networking/storage/IStackWatcherHost;", "Lcom/the9grounds/aeadditions/gui/widget/fluid/IFluidSlotListener;", "()V", "clientRedstoneOutput", "", "currentAmount", "", "getCurrentAmount", "()J", "setCurrentAmount", "(J)V", "mode", "Lappeng/api/config/RedstoneMode;", "previousState", "selectedFluid", "Lnet/minecraftforge/fluids/Fluid;", "getSelectedFluid", "()Lnet/minecraftforge/fluids/Fluid;", "setSelectedFluid", "(Lnet/minecraftforge/fluids/Fluid;)V", "wantedAmount", "watcher", "Lappeng/api/networking/storage/IStackWatcher;", "canConnectRedstone", "changeWantedAmount", "", "modifier", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getBoxes", "bch", "Lappeng/api/parts/IPartCollisionHelper;", "getCableConnectionLength", "", "aeCableType", "Lappeng/api/util/AECableType;", "getCableConnectionType", "dir", "Lappeng/api/util/AEPartLocation;", "getClientGuiElement", "", "getPowerUsage", "", "getServerGuiElement", "getStaticModels", "Lappeng/api/parts/IPartModel;", "getWantedAmount", "isLevelEmitterOn", "isProvidingStrongPower", "isProvidingWeakPower", "notifyTargetBlock", "tileEntity", "Lnet/minecraft/tileentity/TileEntity;", "facing", "Lnet/minecraft/util/EnumFacing;", "onActivate", "hand", "Lnet/minecraft/util/EnumHand;", "pos", "Lnet/minecraft/util/math/Vec3d;", "onStackChange", "o", "Lappeng/api/storage/data/IItemList;", "fullStack", "Lappeng/api/storage/data/IAEStack;", "diffStack", "src", "Lappeng/api/networking/security/IActionSource;", "chan", "Lappeng/api/storage/IStorageChannel;", "randomDisplayTick", "world", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "random", "Ljava/util/Random;", "readFromNBT", "data", "Lnet/minecraft/nbt/NBTTagCompound;", "readFromStream", "Lio/netty/buffer/ByteBuf;", "setFluid", "index", "fluid", "setWantedAmount", "syncClientGui", "toggleMode", "updateWatcher", "newWatcher", "writeToNBT", "writeToStream", "AEAdditions-1.12.2"})
public final class PartGasLevelEmitter
extends PartECBase
implements IStackWatcherHost,
IFluidSlotListener {
    @Nullable
    private Fluid selectedFluid;
    private RedstoneMode mode = RedstoneMode.HIGH_SIGNAL;
    private IStackWatcher watcher;
    private long wantedAmount;
    private long currentAmount;
    private boolean previousState;
    private boolean clientRedstoneOutput;

    @Nullable
    protected final Fluid getSelectedFluid() {
        return this.selectedFluid;
    }

    protected final void setSelectedFluid(@Nullable Fluid fluid) {
        this.selectedFluid = fluid;
    }

    protected final long getCurrentAmount() {
        return this.currentAmount;
    }

    protected final void setCurrentAmount(long l) {
        this.currentAmount = l;
    }

    public float getCableConnectionLength(@Nullable AECableType aeCableType) {
        return 16.0f;
    }

    @Override
    @NotNull
    public AECableType getCableConnectionType(@NotNull AEPartLocation dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        return AECableType.SMART;
    }

    public final void changeWantedAmount(int modifier, @Nullable EntityPlayer player) {
        this.setWantedAmount(this.wantedAmount + (long)modifier, player);
    }

    @Override
    public void getBoxes(@NotNull IPartCollisionHelper bch) {
        Intrinsics.checkParameterIsNotNull((Object)bch, (String)"bch");
        bch.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @Override
    @Nullable
    public Object getClientGuiElement(@Nullable EntityPlayer player) {
        return new GuiGasEmitter(this, player);
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    @Nullable
    public Object getServerGuiElement(@Nullable EntityPlayer player) {
        return new ContainerGasEmitter(this, player);
    }

    private final boolean isLevelEmitterOn() {
        boolean bl;
        FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fMLCommonHandler, (String)"FMLCommonHandler.instance()");
        Side side = fMLCommonHandler.getEffectiveSide();
        Intrinsics.checkExpressionValueIsNotNull((Object)side, (String)"FMLCommonHandler.instance().effectiveSide");
        if (side.isClient()) {
            return this.clientRedstoneOutput;
        }
        IGridNode gridNode = this.getGridNode();
        if (gridNode == null || !gridNode.isActive()) {
            bl = false;
        } else {
            switch (PartGasLevelEmitter$WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
                case 1: {
                    if (this.wantedAmount >= this.currentAmount) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (this.wantedAmount <= this.currentAmount) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public int isProvidingStrongPower() {
        return this.isLevelEmitterOn() ? 15 : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.isProvidingStrongPower();
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public final void notifyTargetBlock(@NotNull TileEntity tileEntity, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull((Object)tileEntity, (String)"tileEntity");
        tileEntity.func_145831_w().func_175685_c(tileEntity.func_174877_v(), Blocks.field_150350_a, true);
        tileEntity.func_145831_w().func_175685_c(tileEntity.func_174877_v().func_177972_a(facing), Blocks.field_150350_a, true);
    }

    @Override
    public boolean onActivate(@Nullable EntityPlayer player, @Nullable EnumHand hand, @Nullable Vec3d pos) {
        PartGasLevelEmitter partGasLevelEmitter = this;
        if (partGasLevelEmitter == null) {
            throw new TypeCastException("null cannot be cast to non-null type appeng.api.parts.IPart");
        }
        return PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, partGasLevelEmitter) ? super.onActivate(player, hand, pos) : false;
    }

    public void onStackChange(@Nullable IItemList<?> o, @Nullable IAEStack<?> fullStack, @Nullable IAEStack<?> diffStack, @Nullable IActionSource src, @NotNull IStorageChannel<?> chan) {
        Intrinsics.checkParameterIsNotNull(chan, (String)"chan");
        IAEGasStack cfr_ignored_0 = (IAEGasStack)fullStack;
        IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
        if (iGasStorageChannel == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual(chan, (Object)iGasStorageChannel) && fullStack != null && Intrinsics.areEqual((Object)((IAEGasStack)fullStack).getGas(), (Object)GasUtil.getGas(this.selectedFluid))) {
            IGridNode node;
            this.currentAmount = ((IAEGasStack)fullStack).getStackSize();
            boolean isOn = this.isLevelEmitterOn();
            if (this.previousState != isOn && (node = this.getGridNode()) != null) {
                this.setActive(node.isActive());
                IPartHost iPartHost = this.getHost();
                if (iPartHost != null) {
                    iPartHost.markForUpdate();
                }
                TileEntity tileEntity = this.getHostTile();
                Intrinsics.checkExpressionValueIsNotNull((Object)tileEntity, (String)"hostTile");
                this.notifyTargetBlock(tileEntity, this.getFacing());
                this.previousState = isOn;
            }
        }
    }

    @Override
    public void randomDisplayTick(@NotNull World world, @NotNull BlockPos blockPos, @NotNull Random random) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"blockPos");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        if (this.isLevelEmitterOn()) {
            EnumFacing facing;
            EnumFacing enumFacing = facing = this.getFacing();
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"facing");
            double d0 = (double)((float)enumFacing.func_82601_c() * 0.45f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)facing.func_96559_d() * 0.45f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)facing.func_82599_e() * 0.45f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            world.func_175688_a(EnumParticleTypes.REDSTONE, 0.5 + (double)blockPos.func_177958_n() + d0, 0.5 + (double)blockPos.func_177956_o() + d1, 0.5 + (double)blockPos.func_177952_p() + d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super.readFromNBT(data);
        this.selectedFluid = FluidRegistry.getFluid((String)data.func_74779_i("fluid"));
        this.mode = RedstoneMode.values()[data.func_74762_e("mode")];
        this.wantedAmount = data.func_74763_f("wantedAmount");
        this.previousState = data.func_74767_n("previousState");
        if (this.wantedAmount < 0L) {
            this.wantedAmount = 0L;
        }
    }

    @Override
    public boolean readFromStream(@NotNull ByteBuf data) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super.readFromStream(data);
        this.clientRedstoneOutput = data.readBoolean();
        this.previousState = data.readBoolean();
        if (this.getHost() != null) {
            this.getHost().markForUpdate();
        }
        return true;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super.writeToNBT(data);
        if (this.selectedFluid != null) {
            Fluid fluid = this.selectedFluid;
            if (fluid == null) {
                Intrinsics.throwNpe();
            }
            data.func_74778_a("fluid", fluid.getName());
        } else {
            data.func_82580_o("fluid");
        }
        data.func_74768_a("mode", this.mode.ordinal());
        data.func_74772_a("wantedAmount", this.wantedAmount);
        data.func_74757_a("previousState", this.previousState);
    }

    @Override
    public void writeToStream(@NotNull ByteBuf data) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super.writeToStream(data);
        data.writeBoolean(this.isLevelEmitterOn());
        data.writeBoolean(this.previousState);
    }

    @Override
    public void setFluid(int index, @Nullable Fluid fluid, @Nullable EntityPlayer player) {
        this.selectedFluid = fluid;
        if (this.watcher == null) {
            return;
        }
        IStackWatcher iStackWatcher = this.watcher;
        if (iStackWatcher == null) {
            Intrinsics.throwNpe();
        }
        iStackWatcher.reset();
        this.updateWatcher(this.watcher);
        if (this.selectedFluid != null) {
            NetworkUtil.sendToPlayer(new PacketFluidSlotUpdate((List)ImmutableList.of((Object)this.selectedFluid)), player);
        }
        this.saveData();
    }

    public final void setWantedAmount(long wantedAmount, @Nullable EntityPlayer player) {
        IGridNode node;
        this.wantedAmount = wantedAmount;
        if (this.wantedAmount < 0L) {
            this.wantedAmount = 0L;
        }
        TileEntity tileEntity = this.getHostTile();
        Intrinsics.checkExpressionValueIsNotNull((Object)tileEntity, (String)"hostTile");
        this.notifyTargetBlock(tileEntity, this.getFacing());
        if (this.getHost() != null) {
            this.getHost().markForUpdate();
        }
        ECBaseGridBlock eCBaseGridBlock = this.getGridBlock();
        Intrinsics.checkExpressionValueIsNotNull((Object)eCBaseGridBlock, (String)"this.gridBlock");
        IMEMonitor<IAEGasStack> iMEMonitor = eCBaseGridBlock.getGasMonitor();
        Intrinsics.checkExpressionValueIsNotNull(iMEMonitor, (String)"this.gridBlock.gasMonitor");
        IAEStack iAEStack = iMEMonitor.getStorageList().findPrecise((IAEStack)new AEGasStack(new GasStack(GasUtil.getGas(this.selectedFluid), 1000)));
        Intrinsics.checkExpressionValueIsNotNull((Object)iAEStack, (String)"this.gridBlock.gasMonito\u2026s.selectedFluid), 1000)))");
        this.currentAmount = ((IAEGasStack)iAEStack).getStackSize();
        boolean isOn = this.isLevelEmitterOn();
        if (this.previousState != isOn && (node = this.getGridNode()) != null) {
            this.setActive(node.isActive());
            IPartHost iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
            TileEntity tileEntity2 = this.getHostTile();
            Intrinsics.checkExpressionValueIsNotNull((Object)tileEntity2, (String)"hostTile");
            this.notifyTargetBlock(tileEntity2, this.getFacing());
            this.previousState = isOn;
        }
        this.saveData();
    }

    public final void syncClientGui(@Nullable EntityPlayer player) {
        NetworkUtil.sendToPlayer(new PacketPartConfig(this, "FluidEmitter.Mode", this.mode.toString()), player);
        NetworkUtil.sendToPlayer(new PacketPartConfig(this, "FluidEmitter.Amount", Long.toString(this.wantedAmount)), player);
        if (this.selectedFluid != null) {
            NetworkUtil.sendToPlayer(new PacketFluidSlotUpdate((List)ImmutableList.of((Object)this.selectedFluid)), player);
        }
    }

    public final long getWantedAmount() {
        return this.wantedAmount;
    }

    public final void toggleMode(@Nullable EntityPlayer player) {
        switch (PartGasLevelEmitter$WhenMappings.$EnumSwitchMapping$1[this.mode.ordinal()]) {
            case 1: {
                this.mode = RedstoneMode.HIGH_SIGNAL;
                break;
            }
            default: {
                this.mode = RedstoneMode.LOW_SIGNAL;
            }
        }
        TileEntity tileEntity = this.getHostTile();
        Intrinsics.checkExpressionValueIsNotNull((Object)tileEntity, (String)"hostTile");
        this.notifyTargetBlock(tileEntity, this.getFacing());
        NetworkUtil.sendToPlayer(new PacketPartConfig(this, "FluidEmitter.Mode", this.mode.toString()), player);
        if (this.getHost() != null) {
            this.getHost().markForUpdate();
        }
        this.saveData();
    }

    public void updateWatcher(@Nullable IStackWatcher newWatcher) {
        this.watcher = newWatcher;
        if (this.selectedFluid != null) {
            IStackWatcher iStackWatcher = this.watcher;
            if (iStackWatcher == null) {
                Intrinsics.throwNpe();
            }
            IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
            if (iGasStorageChannel == null) {
                Intrinsics.throwNpe();
            }
            iStackWatcher.add(iGasStorageChannel.createStack(new FluidStack(this.selectedFluid, 1000)));
        }
    }

    @NotNull
    public IPartModel getStaticModels() {
        return this.isActive() && this.isPowered() ? (IPartModel)(this.isLevelEmitterOn() ? PartModels.EMITTER_ON_HAS_CHANNEL : PartModels.EMITTER_OFF_HAS_CHANNEL) : (IPartModel)(this.isPowered() ? (this.isLevelEmitterOn() ? PartModels.EMITTER_ON_ON : PartModels.EMITTER_OFF_ON) : (this.isLevelEmitterOn() ? PartModels.EMITTER_ON_OFF : PartModels.EMITTER_OFF_OFF));
    }
}

