/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.registries;

import com.the9grounds.aeadditions.integration.Integration;
import com.the9grounds.aeadditions.item.ItemFluid;
import com.the9grounds.aeadditions.item.ItemFluidPattern;
import com.the9grounds.aeadditions.item.ItemGas;
import com.the9grounds.aeadditions.item.ItemInternalCraftingPattern;
import com.the9grounds.aeadditions.item.ItemOCUpgrade;
import com.the9grounds.aeadditions.item.ItemPartECBase;
import com.the9grounds.aeadditions.item.ItemWirelessTerminalFluid;
import com.the9grounds.aeadditions.item.ItemWirelessTerminalGas;
import com.the9grounds.aeadditions.item.ItemWirelessTerminalUniversal;
import com.the9grounds.aeadditions.item.storage.ItemStorageCasing;
import com.the9grounds.aeadditions.item.storage.ItemStorageCellFluid;
import com.the9grounds.aeadditions.item.storage.ItemStorageCellGas;
import com.the9grounds.aeadditions.item.storage.ItemStorageCellPhysical;
import com.the9grounds.aeadditions.item.storage.ItemStorageCellPortableFluid;
import com.the9grounds.aeadditions.item.storage.ItemStorageCellPortableGas;
import com.the9grounds.aeadditions.item.storage.ItemStorageComponent;
import com.the9grounds.aeadditions.util.CreativeTabEC;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public enum ItemEnum {
    PARTITEM("part.base", new ItemPartECBase()),
    FLUIDSTORAGE("storage.fluid", new ItemStorageCellFluid()),
    PHYSICALSTORAGE("storage.physical", new ItemStorageCellPhysical()),
    GASSTORAGE("storage.gas", new ItemStorageCellGas(), Integration.Mods.MEKANISMGAS),
    FLUIDPATTERN("pattern.fluid", new ItemFluidPattern()),
    FLUIDWIRELESSTERMINAL("terminal.fluid.wireless", ItemWirelessTerminalFluid.INSTANCE),
    STORAGECOMPONET("storage.component", new ItemStorageComponent()),
    STORAGECASING("storage.casing", new ItemStorageCasing()),
    FLUIDITEM("fluid.item", new ItemFluid(), null, null, true),
    FLUIDSTORAGEPORTABLE("storage.fluid.portable", new ItemStorageCellPortableFluid()),
    GASSTORAGEPORTABLE("storage.gas.portable", new ItemStorageCellPortableGas(), Integration.Mods.MEKANISMGAS),
    CRAFTINGPATTERN("pattern.crafting", new ItemInternalCraftingPattern(), null, null, true),
    UNIVERSALTERMINAL("terminal.universal.wireless", new ItemWirelessTerminalUniversal()),
    GASWIRELESSTERMINAL("terminal.gas.wireless", ItemWirelessTerminalGas.INSTANCE, Integration.Mods.MEKANISMGAS),
    OCUPGRADE("oc.upgrade", (Item)ItemOCUpgrade.INSTANCE, Integration.Mods.OPENCOMPUTERS, false),
    GASITEM("gas.item", ItemGas.INSTANCE, Integration.Mods.MEKANISMGAS, null, true);

    private final String internalName;
    private Item item;
    private Integration.Mods mod;
    private Boolean enabled = true;

    private ItemEnum(String internalName, Item item) {
        this(internalName, item, null);
    }

    private ItemEnum(String internalName, Item item, Integration.Mods mod) {
        this(internalName, item, mod, CreativeTabEC.INSTANCE);
    }

    private ItemEnum(String internalName, Item item, Integration.Mods mod, Boolean enabled) {
        this(internalName, item, mod, CreativeTabEC.INSTANCE);
        this.enabled = enabled;
    }

    private ItemEnum(String internalName, Item item, Integration.Mods mod, CreativeTabs creativeTab) {
        this.internalName = internalName;
        this.item = item;
        this.item.func_77655_b("com.the9grounds.aeadditions." + this.internalName);
        this.item.setRegistryName(this.internalName);
        this.mod = mod;
        if (creativeTab != null && (mod == null || mod.isEnabled())) {
            this.item.func_77637_a(creativeTab);
        }
    }

    private ItemEnum(String internalName, Item item, Integration.Mods mod, CreativeTabs creativeTab, Boolean enabled) {
        this.internalName = internalName;
        this.item = item;
        this.item.func_77655_b("com.the9grounds.aeadditions." + this.internalName);
        this.item.setRegistryName(this.internalName);
        this.mod = mod;
        if (creativeTab != null && (mod == null || mod.isEnabled())) {
            this.item.func_77637_a(creativeTab);
        }
        this.enabled = enabled;
    }

    public ItemStack getDamagedStack(int damage) {
        return new ItemStack(this.item, 1, damage);
    }

    public String getInternalName() {
        return this.internalName;
    }

    public Item getItem() {
        return this.item;
    }

    public ItemStack getSizedStack(int size) {
        return new ItemStack(this.item, size);
    }

    public String getStatName() {
        return I18n.func_74838_a((String)this.item.func_77658_a());
    }

    public Integration.Mods getMod() {
        return this.mod;
    }

    public boolean shouldRegister() {
        return this.mod == null || this.mod.isEnabled();
    }

    public Boolean isEnabled() {
        return this.enabled;
    }
}

