/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.client;

import java.util.ArrayList;
import net.montoyo.mcef.api.IDisplayHandler;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserOsr;
import org.cef.browser.CefFrame;
import org.cef.handler.CefDisplayHandler;

public class DisplayHandler
implements CefDisplayHandler {
    private final ArrayList<IDisplayHandler> list = new ArrayList();
    private final ArrayList<EventData> queue = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
        ArrayList<EventData> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.add(new EventData(browser, url, EventType.ADDRESS_CHANGE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTitleChange(CefBrowser browser, String title) {
        ArrayList<EventData> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.add(new EventData(browser, title, EventType.TITLE_CHANGE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onTooltip(CefBrowser browser, String text) {
        ArrayList<EventData> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.add(new EventData(browser, text, EventType.TOOLTIP));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatusMessage(CefBrowser browser, String value) {
        ArrayList<EventData> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.add(new EventData(browser, value, EventType.STATUS_MESSAGE));
        }
    }

    @Override
    public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
        return false;
    }

    public void addHandler(IDisplayHandler h) {
        this.list.add(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        ArrayList<EventData> arrayList = this.queue;
        synchronized (arrayList) {
            while (!this.queue.isEmpty()) {
                EventData ed = this.queue.remove(0);
                for (IDisplayHandler idh : this.list) {
                    ed.execute(idh);
                }
            }
        }
    }

    private static final class EventData {
        private final CefBrowser browser;
        private final String data;
        private final EventType type;

        private EventData(CefBrowser b, String d, EventType t) {
            this.browser = b;
            this.data = d;
            this.type = t;
        }

        private void execute(IDisplayHandler idh) {
            switch (this.type) {
                case ADDRESS_CHANGE: {
                    idh.onAddressChange((CefBrowserOsr)this.browser, this.data);
                    break;
                }
                case TITLE_CHANGE: {
                    idh.onTitleChange((CefBrowserOsr)this.browser, this.data);
                    break;
                }
                case TOOLTIP: {
                    idh.onTooltip((CefBrowserOsr)this.browser, this.data);
                    break;
                }
                case STATUS_MESSAGE: {
                    idh.onStatusMessage((CefBrowserOsr)this.browser, this.data);
                }
            }
        }
    }

    private static enum EventType {
        ADDRESS_CHANGE,
        TITLE_CHANGE,
        TOOLTIP,
        STATUS_MESSAGE;

    }
}

