/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkedBlock;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public abstract class LinkableBlockEntity
extends CustomizableBlockEntity
implements ITickable {
    private List<LinkedBlock> linkedBlocks = new ArrayList<LinkedBlock>();
    private NBTTagList nbtTagStorage = null;

    public void func_73660_a() {
        if (this.func_145830_o() && this.nbtTagStorage != null) {
            this.readLinkedBlocks(this.nbtTagStorage);
            this.sync();
            this.nbtTagStorage = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("linkedBlocks")) {
            if (!this.func_145830_o()) {
                this.nbtTagStorage = tag.func_150295_c("linkedBlocks", 10);
                return;
            }
            this.readLinkedBlocks(tag.func_150295_c("linkedBlocks", 10));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.func_145830_o() && !this.linkedBlocks.isEmpty()) {
            NBTTagList tagList = new NBTTagList();
            LevelUtils.addScheduledTask(this.field_145850_b, () -> {
                for (int i = this.linkedBlocks.size() - 1; i >= 0; --i) {
                    LinkedBlock block = this.linkedBlocks.get(i);
                    NBTTagCompound toAppend = new NBTTagCompound();
                    if (block != null) {
                        if (this.field_145850_b.func_175667_e(block.getPos()) && !block.validate(this.field_145850_b)) {
                            this.linkedBlocks.remove(i);
                            continue;
                        }
                        toAppend.func_74778_a("blockName", block.getBlockName());
                        toAppend.func_74768_a("blockX", block.getX());
                        toAppend.func_74768_a("blockY", block.getY());
                        toAppend.func_74768_a("blockZ", block.getZ());
                    }
                    tagList.func_74742_a((NBTBase)toAppend);
                }
                tag.func_74782_a("linkedBlocks", (NBTBase)tagList);
            });
        }
        return tag;
    }

    private void readLinkedBlocks(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String name = list.func_150305_b(i).func_74779_i("blockName");
            int x = list.func_150305_b(i).func_74762_e("blockX");
            int y = list.func_150305_b(i).func_74762_e("blockY");
            int z = list.func_150305_b(i).func_74762_e("blockZ");
            LinkedBlock block = new LinkedBlock(name, new BlockPos(x, y, z));
            if (this.func_145830_o() && !block.validate(this.field_145850_b)) {
                list.func_74744_a(i);
                continue;
            }
            if (this.linkedBlocks.contains(block)) continue;
            LinkableBlockEntity.link(this, block.asTileEntity(this.field_145850_b));
        }
    }

    public void func_145843_s() {
        for (LinkedBlock block : this.linkedBlocks) {
            if (!this.field_145850_b.func_175667_e(block.getPos())) continue;
            LinkableBlockEntity.unlink(block.asTileEntity(this.field_145850_b), this);
        }
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        this.createLinkedBlockAction(new ILinkedAction.OptionChanged(option), this);
    }

    public static void link(LinkableBlockEntity tileEntity1, LinkableBlockEntity tileEntity2) {
        if (LinkableBlockEntity.isLinkedWith(tileEntity1, tileEntity2)) {
            return;
        }
        LinkedBlock block1 = new LinkedBlock(tileEntity1);
        LinkedBlock block2 = new LinkedBlock(tileEntity2);
        if (!tileEntity1.linkedBlocks.contains(block2)) {
            tileEntity1.linkedBlocks.add(block2);
        }
        if (!tileEntity2.linkedBlocks.contains(block1)) {
            tileEntity2.linkedBlocks.add(block1);
        }
    }

    public static void unlink(LinkableBlockEntity tileEntity1, LinkableBlockEntity tileEntity2) {
        if (tileEntity1 == null || tileEntity2 == null) {
            return;
        }
        LinkedBlock block = new LinkedBlock(tileEntity2);
        if (tileEntity1.linkedBlocks.contains(block)) {
            tileEntity1.linkedBlocks.remove(block);
        }
    }

    public static boolean isLinkedWith(LinkableBlockEntity tileEntity1, LinkableBlockEntity tileEntity2) {
        return tileEntity1.linkedBlocks.contains(new LinkedBlock(tileEntity2)) && tileEntity2.linkedBlocks.contains(new LinkedBlock(tileEntity1));
    }

    public void createLinkedBlockAction(ILinkedAction action, LinkableBlockEntity excludedTE) {
        ArrayList<LinkableBlockEntity> list = new ArrayList<LinkableBlockEntity>();
        list.add(excludedTE);
        this.createLinkedBlockAction(action, list);
    }

    public void createLinkedBlockAction(ILinkedAction action, List<LinkableBlockEntity> excludedTEs) {
        for (LinkedBlock block : this.linkedBlocks) {
            LinkableBlockEntity linkedTe = block.asTileEntity(this.field_145850_b);
            if (excludedTEs.contains(linkedTe)) continue;
            linkedTe.onLinkedBlockAction(action, excludedTEs);
            if (this.field_145850_b.field_72995_K) continue;
            linkedTe.sync();
        }
    }

    protected void onLinkedBlockAction(ILinkedAction action, List<LinkableBlockEntity> excludedTEs) {
    }
}

