/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.screen.components.Slider;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class Option<T> {
    private String name;
    protected T value;
    private T defaultValue;
    private T increment;
    private T minimum;
    private T maximum;

    protected Option(String optionName, T value) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
    }

    protected Option(String optionName, T value, T min, T max, T increment) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
        this.increment = increment;
        this.minimum = min;
        this.maximum = max;
    }

    public abstract void toggle();

    public abstract void load(NBTTagCompound var1);

    public abstract void save(NBTTagCompound var1);

    public void copy(Option<?> option) {
        this.value = option.get();
    }

    public final String getName() {
        return this.name;
    }

    public T get() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getIncrement() {
        return this.increment;
    }

    public T getMin() {
        return this.minimum;
    }

    public T getMax() {
        return this.maximum;
    }

    public boolean isSlider() {
        return false;
    }

    public String getKey(Block block) {
        return "option." + block.func_149739_a().substring(5) + "." + this.getName();
    }

    public String getDescriptionKey(Block block) {
        return this.getKey(block) + ".description";
    }

    public ITextComponent getDefaultInfo() {
        return Utils.localize("securitycraft.option.default_with_range", this.getDefaultValue(), this.getMin(), this.getMax()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
    }

    public String toString() {
        return this.value + "";
    }

    public static class EnumOption<T extends Enum<T>>
    extends Option<T> {
        private final Class<T> enumClass;

        protected EnumOption(String optionName, T value, Class<T> enumClass) {
            super(optionName, value);
            this.enumClass = enumClass;
        }

        @Override
        public void toggle() {
            Enum[] enumConstants = (Enum[])this.enumClass.getEnumConstants();
            int next = (((Enum)this.value).ordinal() + 1) % enumConstants.length;
            this.value = enumConstants[next];
        }

        @Override
        public void load(NBTTagCompound tag) {
            Enum[] enumConstants = (Enum[])this.enumClass.getEnumConstants();
            int ordinal = tag.func_74762_e(this.getName());
            this.value = ordinal >= 0 && ordinal < enumConstants.length ? enumConstants[ordinal] : this.getDefaultValue();
        }

        @Override
        public void save(NBTTagCompound tag) {
            tag.func_74768_a(this.getName(), ((Enum)this.value).ordinal());
        }

        public ITextComponent getValueName() {
            return new TextComponentString(((Enum)this.value).name());
        }

        @Override
        public ITextComponent getDefaultInfo() {
            return Utils.localize("securitycraft.option.default", this.getValueName()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
        }
    }

    public static class FloatOption
    extends Option<Float> {
        public FloatOption(String optionName, Float value, Float min, Float max, Float increment) {
            super(optionName, value, min, max, increment);
        }

        @Override
        public void toggle() {
            if (((Float)this.get()).floatValue() >= ((Float)this.getMax()).floatValue()) {
                this.setValue(this.getMin());
                return;
            }
            if (((Float)this.get()).floatValue() + ((Float)this.getIncrement()).floatValue() >= ((Float)this.getMax()).floatValue()) {
                this.setValue(this.getMax());
                return;
            }
            this.setValue(Float.valueOf(((Float)this.get()).floatValue() + ((Float)this.getIncrement()).floatValue()));
        }

        @Override
        public void load(NBTTagCompound tag) {
            this.value = tag.func_74764_b(this.getName()) ? Float.valueOf(tag.func_74760_g(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(NBTTagCompound tag) {
            tag.func_74776_a(this.getName(), ((Float)this.value).floatValue());
        }

        @Override
        public String toString() {
            return Float.toString(((Float)this.value).floatValue()).length() > 5 ? Float.toString(((Float)this.value).floatValue()).substring(0, 5) : Float.toString(((Float)this.value).floatValue());
        }
    }

    public static class DoubleOption
    extends Option<Double>
    implements Slider.ISlider {
        private boolean isSlider;
        private Supplier<BlockPos> pos;

        public DoubleOption(String optionName, Double value, Double min, Double max, Double increment) {
            super(optionName, value, min, max, increment);
            this.isSlider = false;
        }

        public DoubleOption(Supplier<BlockPos> pos, String optionName, Double value, Double min, Double max, Double increment, boolean isSlider) {
            super(optionName, value, min, max, increment);
            this.isSlider = isSlider;
            this.pos = pos;
        }

        @Override
        public void toggle() {
            if (this.isSlider()) {
                return;
            }
            if ((Double)this.get() >= (Double)this.getMax()) {
                this.setValue(this.getMin());
                return;
            }
            if ((Double)this.get() + (Double)this.getIncrement() >= (Double)this.getMax()) {
                this.setValue(this.getMax());
                return;
            }
            this.setValue((Double)this.get() + (Double)this.getIncrement());
        }

        @Override
        public void load(NBTTagCompound tag) {
            this.value = tag.func_74764_b(this.getName()) ? Double.valueOf(tag.func_74769_h(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(NBTTagCompound tag) {
            tag.func_74780_a(this.getName(), ((Double)this.value).doubleValue());
        }

        @Override
        public String toString() {
            return Double.toString((Double)this.value).length() > 5 ? Double.toString((Double)this.value).substring(0, 5) : Double.toString((Double)this.value);
        }

        @Override
        public boolean isSlider() {
            return this.isSlider;
        }

        @Override
        public void onChangeSliderValue(Slider slider, Block block, int id) {
            if (!this.isSlider()) {
                return;
            }
            this.setValue(slider.getValue());
            slider.field_146126_j = (Utils.localize(this.getKey(block), new Object[0]).func_150254_d() + " ").replace("#", this.toString());
        }

        @Override
        public void onMouseRelease(int id) {
            SecurityCraft.network.sendToServer((IMessage)new UpdateSliderValue(this.pos.get(), id, (Double)this.get()));
        }
    }

    public static class SignalLengthOption
    extends IntOption {
        public SignalLengthOption(Supplier<BlockPos> pos, int defaultLength) {
            super(pos, "signalLength", defaultLength, 0, 400, 5, true);
        }

        @Override
        public String getKey(Block block) {
            return "option.generic.signalLength";
        }
    }

    public static class SmartModuleCooldownOption
    extends IntOption {
        public SmartModuleCooldownOption(Supplier<BlockPos> pos) {
            super(pos, "smartModuleCooldown", 100, 20, 400, 1, true);
        }

        @Override
        public String getKey(Block block) {
            return "option.generic.smartModuleCooldown";
        }
    }

    public static class IntOption
    extends Option<Integer>
    implements Slider.ISlider {
        private boolean isSlider;
        private Supplier<BlockPos> pos;

        public IntOption(String optionName, Integer value, Integer min, Integer max, Integer increment) {
            super(optionName, value, min, max, increment);
            this.isSlider = false;
        }

        public IntOption(Supplier<BlockPos> pos, String optionName, Integer value, Integer min, Integer max, Integer increment, boolean isSlider) {
            super(optionName, value, min, max, increment);
            this.isSlider = isSlider;
            this.pos = pos;
        }

        @Override
        public void toggle() {
            if (this.isSlider()) {
                return;
            }
            if ((Integer)this.get() >= (Integer)this.getMax()) {
                this.setValue(this.getMin());
                return;
            }
            if ((Integer)this.get() + (Integer)this.getIncrement() >= (Integer)this.getMax()) {
                this.setValue(this.getMax());
                return;
            }
            this.setValue((Integer)this.get() + (Integer)this.getIncrement());
        }

        @Override
        public void load(NBTTagCompound tag) {
            this.value = tag.func_74764_b(this.getName()) ? Integer.valueOf(tag.func_74762_e(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(NBTTagCompound tag) {
            tag.func_74768_a(this.getName(), ((Integer)this.value).intValue());
        }

        @Override
        public boolean isSlider() {
            return this.isSlider;
        }

        @Override
        public void onChangeSliderValue(Slider slider, Block block, int id) {
            if (!this.isSlider()) {
                return;
            }
            this.setValue((int)slider.getValue());
            slider.field_146126_j = (Utils.localize(this.getKey(block), new Object[0]).func_150254_d() + " ").replace("#", this.toString());
        }

        @Override
        public void onMouseRelease(int id) {
            SecurityCraft.network.sendToServer((IMessage)new UpdateSliderValue(this.pos.get(), id, ((Integer)this.get()).intValue()));
        }
    }

    public static class IgnoreOwnerOption
    extends BooleanOption {
        public IgnoreOwnerOption(Boolean value) {
            super("ignoreOwner", value);
        }

        @Override
        public String getKey(Block block) {
            return "option.generic.ignoreOwner";
        }
    }

    public static class DisabledOption
    extends BooleanOption {
        public DisabledOption(Boolean value) {
            super("disabled", value);
        }

        @Override
        public String getKey(Block block) {
            return "option.generic.disabled";
        }
    }

    public static class BooleanOption
    extends Option<Boolean> {
        public BooleanOption(String optionName, Boolean value) {
            super(optionName, value);
        }

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
        }

        @Override
        public void load(NBTTagCompound tag) {
            this.value = tag.func_74764_b(this.getName()) ? Boolean.valueOf(tag.func_74767_n(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(NBTTagCompound tag) {
            tag.func_74757_a(this.getName(), ((Boolean)this.value).booleanValue());
        }

        @Override
        public ITextComponent getDefaultInfo() {
            return Utils.localize("securitycraft.option.default", new TextComponentTranslation((Boolean)this.getDefaultValue() != false ? "gui.securitycraft:invScan.yes" : "gui.securitycraft:invScan.no", new Object[0]).func_150254_d()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
        }
    }
}

