/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.KeypadTrapDoorBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;

public class KeypadTrapdoorBlockEntity
extends CustomizableBlockEntity
implements IPasscodeProtected,
ILockable {
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((KeypadTrapdoorBlockEntity)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption(() -> ((KeypadTrapdoorBlockEntity)this).func_174877_v());
    private long cooldownEnd = 0L;
    private byte[] passcode;
    private UUID saltKey;

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        long cooldownLeft;
        super.func_189515_b(tag);
        if (this.saltKey != null) {
            tag.func_186854_a("saltKey", this.saltKey);
        }
        if (this.passcode != null) {
            tag.func_74778_a("passcode", PasscodeUtils.bytesToString(this.passcode));
        }
        tag.func_74772_a("cooldownLeft", (cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis()) <= 0L ? -1L : cooldownLeft);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
        this.cooldownEnd = System.currentTimeMillis() + tag.func_74763_f("cooldownLeft");
    }

    @Override
    public void activate(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            ((KeypadTrapDoorBlock)this.func_145838_q()).activate(this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b, this.field_174879_c, (Integer)this.signalLength.get());
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(IBlockState state, EntityPlayer player) {
        if (this.isDisabled()) {
            player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b) == false && IPasscodeProtected.super.shouldAttemptCodebreak(state, player);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        if (option.getName().equals("disabled")) {
            boolean isDisabled = (Boolean)((Option.BooleanOption)option).get();
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (isDisabled && ((Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b)).booleanValue()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(false)));
                SCContent.keypadTrapdoor.func_185731_a(null, this.field_145850_b, this.field_174879_c, false);
            }
        }
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
        this.func_70296_d();
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.cooldownEnd = System.currentTimeMillis() + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled, this.smartModuleCooldown};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

