/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ScannerTrapdoorBlockEntity
extends CustomizableBlockEntity
implements IViewActivated,
ITickable,
ILockable {
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    protected Option.IntOption signalLength = new Option.IntOption(() -> ((ScannerTrapdoorBlockEntity)this).func_174877_v(), "signalLength", 0, 0, 400, 5, true);
    private Option.DoubleOption maximumDistance = new Option.DoubleOption(() -> ((ScannerTrapdoorBlockEntity)this).func_174877_v(), "maximumDistance", 5.0, 0.1, 25.0, 0.1, true){

        @Override
        public String getKey(Block block) {
            return "option.generic.viewActivated.maximumDistance";
        }
    };
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private int viewCooldown = 0;

    public void func_73660_a() {
        this.checkView(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public boolean onEntityViewed(EntityLivingBase entity, RayTraceResult hitResult) {
        if (!EntityUtils.isInvisible(entity)) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(entity instanceof EntityPlayer) || !((Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b) == false ? hitResult.field_178784_b.func_176740_k() == EnumFacing.Axis.Y : hitResult.field_178784_b.func_176740_k() == ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176740_k())) {
                return false;
            }
            EntityPlayer player = (EntityPlayer)entity;
            if (!this.isLocked() && !this.isDisabled()) {
                boolean shouldBeOpen;
                Owner viewingPlayer = new Owner(player);
                if (ConfigHandler.trickScannersWithPlayerHeads && player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == Items.field_151144_bL) {
                    viewingPlayer = PlayerUtils.getSkullOwner(player);
                }
                if (!this.isOwnedBy(viewingPlayer) && !this.isAllowed(viewingPlayer.getName())) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize((Block)SCContent.scannerTrapdoor, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:retinalScanner.notOwner", PlayerUtils.getOwnerComponent(this.getOwner())), TextFormatting.RED);
                    return true;
                }
                boolean bl = shouldBeOpen = (Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b) == false;
                if (shouldBeOpen && ((Boolean)this.sendMessage.get()).booleanValue()) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize((Block)SCContent.scannerTrapdoor, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:retinalScanner.hello", viewingPlayer.getName()), TextFormatting.GREEN);
                }
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(shouldBeOpen)));
                BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, (Block)SCContent.scannerTrapdoor);
                this.field_145850_b.func_175704_b(this.field_174879_c.func_177977_b(), this.field_174879_c);
                SCContent.scannerTrapdoor.func_185731_a(null, this.field_145850_b, this.field_174879_c, shouldBeOpen);
                if (this.getSignalLength() > 0) {
                    this.field_145850_b.func_175684_a(this.field_174879_c, (Block)SCContent.scannerTrapdoor, this.getSignalLength());
                }
            } else if (this.isLocked() && ((Boolean)this.sendMessage.get()).booleanValue()) {
                TextComponentTranslation blockName = Utils.localize((Block)SCContent.scannerTrapdoor, new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)blockName, (ITextComponent)Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), TextFormatting.DARK_RED, false);
            } else if (this.isDisabled()) {
                player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getViewCooldown() {
        return this.viewCooldown;
    }

    @Override
    public void setViewCooldown(int viewCooldown) {
        this.viewCooldown = viewCooldown;
        this.func_70296_d();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public double getMaximumDistance() {
        return (Double)this.maximumDistance.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled, this.maximumDistance};
    }
}

