/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.List;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class SpecialDoorBlockEntity
extends LinkableBlockEntity
implements ILockable {
    protected Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    protected Option.IntOption signalLength = new Option.IntOption(() -> ((SpecialDoorBlockEntity)this).func_174877_v(), "signalLength", this.defaultSignalLength(), 0, 400, 5, true);
    protected Option.DisabledOption disabled = new Option.DisabledOption(false);

    @Override
    public void onOwnerChanged(IBlockState state, World world, BlockPos pos, EntityPlayer player) {
        pos = state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? pos.func_177977_b() : pos.func_177984_a();
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SpecialDoorBlockEntity && SpecialDoorBlockEntity.isLinkedWith(this, (SpecialDoorBlockEntity)te)) {
            ((SpecialDoorBlockEntity)te).setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!world.field_72995_K) {
                world.func_73046_m().func_184103_al().func_148540_a((Packet)te.func_189518_D_());
            }
        }
    }

    @Override
    protected void onLinkedBlockAction(ILinkedAction action, List<LinkableBlockEntity> excludedTEs) {
        if (action instanceof ILinkedAction.OptionChanged) {
            Option option = ((ILinkedAction.OptionChanged)action).option;
            for (Option option2 : this.customOptions()) {
                if (!option2.getName().equals(option.getName())) continue;
                option2.copy(option);
                break;
            }
        } else if (action instanceof ILinkedAction.ModuleInserted) {
            ILinkedAction.ModuleInserted moduleInserted = (ILinkedAction.ModuleInserted)action;
            this.insertModule(moduleInserted.stack, moduleInserted.wasModuleToggled);
        } else if (action instanceof ILinkedAction.ModuleRemoved) {
            ILinkedAction.ModuleRemoved moduleRemoved = (ILinkedAction.ModuleRemoved)action;
            this.removeModule(moduleRemoved.moduleType, moduleRemoved.wasModuleToggled);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public abstract int defaultSignalLength();
}

