/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.function.Function;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreDictionary;

public class KeypadChestBlock
extends OwnableBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB NORTH_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.875, 0.9375);
    protected static final AxisAlignedBB SOUTH_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 1.0);
    protected static final AxisAlignedBB WEST_CHEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    protected static final AxisAlignedBB EAST_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 1.0, 0.875, 0.9375);
    protected static final AxisAlignedBB NOT_CONNECTED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    public KeypadChestBlock() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(SoundType.field_185852_e);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177978_c()).func_177230_c() == this) {
            return NORTH_CHEST_AABB;
        }
        if (world.func_180495_p(pos.func_177968_d()).func_177230_c() == this) {
            return SOUTH_CHEST_AABB;
        }
        if (world.func_180495_p(pos.func_177976_e()).func_177230_c() == this) {
            return WEST_CHEST_AABB;
        }
        return world.func_180495_p(pos.func_177974_f()).func_177230_c() == this ? EAST_CHEST_AABB : NOT_CONNECTED_AABB;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.checkForSurroundingChests(world, pos, state);
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            IBlockState offsetState = world.func_180495_p(offsetPos);
            if (offsetState.func_177230_c() != this) continue;
            this.checkForSurroundingChests(world, offsetPos, offsetState);
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        KeypadChestBlockEntity te;
        if (!world.field_72995_K && (te = (KeypadChestBlockEntity)world.func_175625_s(pos)).verifyPasscodeSet(world, pos, te, player)) {
            if (te.isDenied((Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                }
                return true;
            }
            if (te.isAllowed((Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
                }
                this.activate(world, pos, player);
            } else if (player.func_184586_b(hand).func_77973_b() != SCContent.codebreaker) {
                te.openPasscodeGUI(world, pos, player);
            }
        }
        return true;
    }

    public void activate(World world, BlockPos pos, EntityPlayer player) {
        if (!KeypadChestBlock.isBlocked(world, pos)) {
            player.func_71007_a((IInventory)this.getLockableContainer(world, pos));
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing facing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)facing);
        BlockPos northPos = pos.func_177978_c();
        BlockPos southPos = pos.func_177968_d();
        BlockPos westPos = pos.func_177976_e();
        BlockPos eastPos = pos.func_177974_f();
        boolean isNorthPPC = this == world.func_180495_p(northPos).func_177230_c();
        boolean isSouthPPC = this == world.func_180495_p(southPos).func_177230_c();
        boolean isWestPPC = this == world.func_180495_p(westPos).func_177230_c();
        boolean isEastPPC = this == world.func_180495_p(eastPos).func_177230_c();
        BlockPos otherChestPos = null;
        if (!(isNorthPPC || isSouthPPC || isWestPPC || isEastPPC)) {
            world.func_180501_a(pos, state, 3);
        } else if (facing.func_176740_k() != EnumFacing.Axis.X || !isNorthPPC && !isSouthPPC) {
            if (facing.func_176740_k() == EnumFacing.Axis.Z && (isWestPPC || isEastPPC)) {
                if (isWestPPC) {
                    world.func_180501_a(westPos, state, 3);
                    otherChestPos = westPos;
                } else {
                    world.func_180501_a(eastPos, state, 3);
                    otherChestPos = eastPos;
                }
                world.func_180501_a(pos, state, 3);
            }
        } else {
            if (isNorthPPC) {
                world.func_180501_a(northPos, state, 3);
                otherChestPos = northPos;
            } else {
                world.func_180501_a(southPos, state, 3);
                otherChestPos = southPos;
            }
            world.func_180501_a(pos, state, 3);
        }
        KeypadChestBlockEntity thisTe = (KeypadChestBlockEntity)world.func_175625_s(pos);
        if (stack.func_82837_s()) {
            thisTe.func_190575_a(stack.func_82833_r());
        }
        if (entity instanceof EntityPlayer) {
            TileEntity otherTe;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)entity));
            if (otherChestPos != null && (otherTe = world.func_175625_s(otherChestPos)) instanceof KeypadChestBlockEntity && thisTe.getOwner().owns((KeypadChestBlockEntity)otherTe)) {
                KeypadChestBlockEntity te = (KeypadChestBlockEntity)otherTe;
                for (ModuleType type : te.getInsertedModules()) {
                    thisTe.insertModule(te.getModule(type), false);
                }
                thisTe.setSendsMessages(te.sendsMessages());
                if (te.getSaltKey() != null) {
                    thisTe.setSaltKey(SaltData.putSalt(te.getSalt()));
                }
                thisTe.setPasscode(te.getPasscode());
            }
        }
    }

    public IBlockState checkForSurroundingChests(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState northState = world.func_180495_p(pos.func_177978_c());
            IBlockState southState = world.func_180495_p(pos.func_177968_d());
            IBlockState westState = world.func_180495_p(pos.func_177976_e());
            IBlockState eastState = world.func_180495_p(pos.func_177974_f());
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (northState.func_177230_c() != this && southState.func_177230_c() != this) {
                boolean isNorthFullBlock = northState.func_185913_b();
                boolean isSouthFullBlock = southState.func_185913_b();
                if (westState.func_177230_c() == this || eastState.func_177230_c() == this) {
                    BlockPos otherPos = westState.func_177230_c() == this ? pos.func_177976_e() : pos.func_177974_f();
                    IBlockState otherNorthState = world.func_180495_p(otherPos.func_177978_c());
                    IBlockState otherSouthState = world.func_180495_p(otherPos.func_177968_d());
                    facing = EnumFacing.SOUTH;
                    EnumFacing otherFacing = westState.func_177230_c() == this ? (EnumFacing)westState.func_177229_b((IProperty)FACING) : (EnumFacing)eastState.func_177229_b((IProperty)FACING);
                    if (otherFacing == EnumFacing.NORTH) {
                        facing = EnumFacing.NORTH;
                    }
                    if ((isNorthFullBlock || otherNorthState.func_185913_b()) && !isSouthFullBlock && !otherSouthState.func_185913_b()) {
                        facing = EnumFacing.SOUTH;
                    }
                    if ((isSouthFullBlock || otherSouthState.func_185913_b()) && !isNorthFullBlock && !otherNorthState.func_185913_b()) {
                        facing = EnumFacing.NORTH;
                    }
                }
            } else {
                BlockPos otherPos = northState.func_177230_c() == this ? pos.func_177978_c() : pos.func_177968_d();
                IBlockState otherWestState = world.func_180495_p(otherPos.func_177976_e());
                IBlockState otherEastState = world.func_180495_p(otherPos.func_177974_f());
                facing = EnumFacing.EAST;
                EnumFacing otherFacing = northState.func_177230_c() == this ? (EnumFacing)northState.func_177229_b((IProperty)FACING) : (EnumFacing)southState.func_177229_b((IProperty)FACING);
                if (otherFacing == EnumFacing.WEST) {
                    facing = EnumFacing.WEST;
                }
                if ((westState.func_185913_b() || otherWestState.func_185913_b()) && !eastState.func_185913_b() && !otherEastState.func_185913_b()) {
                    facing = EnumFacing.EAST;
                }
                if ((eastState.func_185913_b() || otherEastState.func_185913_b()) && !westState.func_185913_b() && !otherWestState.func_185913_b()) {
                    facing = EnumFacing.WEST;
                }
            }
            state = state.func_177226_a((IProperty)FACING, (Comparable)facing);
            world.func_180501_a(pos, state, 3);
        }
        return state;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        int surroundingChests = 0;
        BlockPos westPos = pos.func_177976_e();
        BlockPos eastPos = pos.func_177974_f();
        BlockPos northPos = pos.func_177978_c();
        BlockPos southPos = pos.func_177968_d();
        if (world.func_180495_p(westPos).func_177230_c() == this) {
            if (this.isDoubleChest(world, westPos)) {
                return false;
            }
            ++surroundingChests;
        }
        if (world.func_180495_p(eastPos).func_177230_c() == this && (this.isDoubleChest(world, eastPos) || ++surroundingChests > 1)) {
            return false;
        }
        if (world.func_180495_p(northPos).func_177230_c() == this && (this.isDoubleChest(world, northPos) || ++surroundingChests > 1)) {
            return false;
        }
        if (world.func_180495_p(southPos).func_177230_c() == this && (this.isDoubleChest(world, southPos) || ++surroundingChests > 1)) {
            return false;
        }
        return surroundingChests <= 1;
    }

    public boolean isDoubleChest(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == this) {
            for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
                if (world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this) continue;
                return true;
            }
        }
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof KeypadChestBlockEntity) {
            ((KeypadChestBlockEntity)tileEntity).func_145836_u();
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof KeypadChestBlockEntity) {
            te.func_145836_u();
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)te));
            world.func_175666_e(pos, (Block)this);
        }
        if (te instanceof IPasscodeProtected) {
            SaltData.removeSalt(((IPasscodeProtected)te).getSaltKey());
        }
        super.func_180663_b(world, pos, state);
    }

    public ILockableContainer getLockableContainer(World worldIn, BlockPos pos) {
        return this.getContainer(worldIn, pos, false);
    }

    public ILockableContainer getContainer(World world, BlockPos pos, boolean allowBlocking) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof KeypadChestBlockEntity)) {
            return null;
        }
        KeypadChestBlockEntity container = (KeypadChestBlockEntity)te;
        if (!allowBlocking && KeypadChestBlock.isBlocked(world, pos)) {
            return null;
        }
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            Block offsetBlock = world.func_180495_p(offsetPos).func_177230_c();
            if (offsetBlock != this) continue;
            if (!allowBlocking && KeypadChestBlock.isBlocked(world, offsetPos)) {
                return null;
            }
            TileEntity otherTE = world.func_175625_s(offsetPos);
            if (!(otherTE instanceof KeypadChestBlockEntity)) continue;
            if (facing != EnumFacing.WEST && facing != EnumFacing.NORTH) {
                container = new InventoryLargeChest("gui.securitycraft:keypadChestDouble", (ILockableContainer)container, (ILockableContainer)((TileEntityChest)otherTE));
                continue;
            }
            container = new InventoryLargeChest("gui.securitycraft:keypadChestDouble", (ILockableContainer)((TileEntityChest)otherTE), (ILockableContainer)container);
        }
        return container;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (!state.func_185897_m()) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        int numPlayersUsing = 0;
        if (te instanceof KeypadChestBlockEntity && ((KeypadChestBlockEntity)te).isModuleEnabled(ModuleType.REDSTONE)) {
            numPlayersUsing = ((KeypadChestBlockEntity)te).field_145987_o;
        }
        return MathHelper.func_76125_a((int)numPlayersUsing, (int)0, (int)15);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? state.func_185911_a(world, pos, side) : 0;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new KeypadChestBlockEntity();
    }

    public static boolean isBlocked(World world, BlockPos pos) {
        return KeypadChestBlock.isBelowSolidBlock(world, pos) || KeypadChestBlock.isOcelotSittingOnChest(world, pos);
    }

    private static boolean isBelowSolidBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).doesSideBlockChestOpening((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN);
    }

    private static boolean isOcelotSittingOnChest(World world, BlockPos pos) {
        for (EntityOcelot ocelot : world.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            if (!ocelot.func_70906_o()) continue;
            return true;
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)this.getLockableContainer(worldIn, pos));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return !this.isDoubleChest(world, pos) && super.rotateBlock(world, pos, axis);
    }

    public static class Convertible
    implements Function<Object, IPasscodeConvertible>,
    IPasscodeConvertible {
        @Override
        public IPasscodeConvertible apply(Object o) {
            return this;
        }

        @Override
        public boolean isValidStateForConversion(IBlockState state) {
            return OreDictionary.getOres((String)"chestWood").stream().anyMatch(stack -> stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() == state.func_177230_c());
        }

        @Override
        public boolean convert(EntityPlayer player, World world, BlockPos pos) {
            EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
            EnumFacing doubleFacing = this.getDoubleChestFacing(world, pos);
            this.convertChest(player, world, pos, facing);
            if (doubleFacing != EnumFacing.UP) {
                BlockPos newPos = pos.func_177972_a(doubleFacing);
                this.convertChest(player, world, newPos, (EnumFacing)world.func_180495_p(newPos).func_177229_b((IProperty)FACING));
            }
            return true;
        }

        private void convertChest(EntityPlayer player, World world, BlockPos pos, EnumFacing facing) {
            TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
            chest.func_184281_d(player);
            NBTTagCompound tag = chest.func_189515_b(new NBTTagCompound());
            chest.func_174888_l();
            world.func_175656_a(pos, SCContent.keypadChest.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing));
            TileEntity newTe = world.func_175625_s(pos);
            ((TileEntityChest)newTe).func_145839_a(tag);
            ((IOwnable)newTe).setOwner(player.func_110124_au().toString(), player.func_70005_c_());
        }

        private EnumFacing getDoubleChestFacing(World world, BlockPos pos) {
            if (world.func_180495_p(pos).func_177230_c() instanceof BlockChest) {
                for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
                    if (!(world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() instanceof BlockChest)) continue;
                    return facing;
                }
            }
            return EnumFacing.UP;
        }
    }
}

