/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Collections;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blockentities.TrackMineBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.IBlockWithNoDrops;
import net.minecraft.block.BlockRail;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TrackMineBlock
extends BlockRail
implements IExplosive,
ITileEntityProvider,
IBlockWithNoDrops {
    public TrackMineBlock() {
        this.func_149672_a(SoundType.field_185852_e);
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldStack = player.func_184586_b(hand);
        Item heldItem = heldStack.func_77973_b();
        if (heldItem == SCContent.mineRemoteAccessTool) {
            return false;
        }
        if (this.isActive(world, pos) && this.isDefusable() && heldItem == SCContent.wireCutters && this.defuseMine(world, pos)) {
            if (!player.func_184812_l_()) {
                heldStack.func_77972_a(1, (EntityLivingBase)player);
            }
            world.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (!this.isActive(world, pos) && heldItem == Items.field_151033_d && this.activateMine(world, pos)) {
            if (!player.func_184812_l_()) {
                heldStack.func_77972_a(1, (EntityLivingBase)player);
            }
            world.func_184133_a(null, pos, SoundEvents.field_187907_gg, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TrackMineBlockEntity && ((TrackMineBlockEntity)te).isActive()) {
            world.func_175655_b(pos, false);
            world.func_72885_a((Entity)cart, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), ConfigHandler.smallerMineExplosion ? 3.0f : 6.0f, ConfigHandler.shouldSpawnFire, ConfigHandler.mineExplosionsBreakBlocks);
            cart.func_70106_y();
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    @Override
    public void explode(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TrackMineBlockEntity && ((TrackMineBlockEntity)te).isActive()) {
            world.func_175655_b(pos, false);
            world.func_72885_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177984_a().func_177956_o(), (double)pos.func_177952_p(), ConfigHandler.smallerMineExplosion ? 3.0f : 6.0f, ConfigHandler.shouldSpawnFire, ConfigHandler.mineExplosionsBreakBlocks);
        }
    }

    @Override
    public boolean activateMine(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TrackMineBlockEntity && !((TrackMineBlockEntity)te).isActive()) {
            ((TrackMineBlockEntity)te).activate();
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TrackMineBlockEntity && ((TrackMineBlockEntity)te).isActive()) {
            ((TrackMineBlockEntity)te).deactivate();
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TrackMineBlockEntity && ((TrackMineBlockEntity)te).isActive();
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TrackMineBlockEntity();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }
}

