/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IEMPAffected;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.CameraNightVisionEffectInstance;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.ToggleNightVision;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SecurityCamera
extends Entity
implements IEMPAffected {
    private int screenshotSoundCooldown = 0;
    protected int redstoneCooldown = 0;
    protected int toggleNightVisionCooldown = 0;
    protected float zoomAmount = 1.0f;
    protected boolean zooming = false;
    private ForgeChunkManager.Ticket chunkTicket;

    public SecurityCamera(World world) {
        super(world);
        this.field_70145_X = true;
        this.field_98038_p = true;
        this.field_70131_O = 1.0E-4f;
        this.field_70130_N = 1.0E-4f;
        if (!world.field_72995_K) {
            this.field_70128_L = true;
        }
    }

    public SecurityCamera(World world, double x, double y, double z) {
        this(world);
        this.field_70128_L = false;
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof SecurityCameraBlockEntity)) {
            this.func_70106_y();
            return;
        }
        SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)te;
        x += 0.5;
        y += 0.5;
        z += 0.5;
        if (cam.isDown()) {
            y += 0.25;
        }
        this.func_70107_b(x, y, z);
        this.setInitialPitchYaw();
    }

    public SecurityCamera(World world, double x, double y, double z, SecurityCamera oldCamera) {
        this(world, x, y, z);
        oldCamera.func_70106_y();
    }

    private void setInitialPitchYaw() {
        this.field_70125_A = 30.0f;
        EnumFacing facing = (EnumFacing)this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_177229_b((IProperty)SecurityCameraBlock.FACING);
        if (facing == EnumFacing.NORTH) {
            this.field_70177_z = 180.0f;
        } else if (facing == EnumFacing.WEST) {
            this.field_70177_z = 90.0f;
        } else if (facing == EnumFacing.SOUTH) {
            this.field_70177_z = 0.0f;
        } else if (facing == EnumFacing.EAST) {
            this.field_70177_z = 270.0f;
        } else if (facing == EnumFacing.DOWN) {
            this.field_70125_A = 75.0f;
        }
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.getScreenshotSoundCooldown() > 0) {
                this.setScreenshotSoundCooldown(this.getScreenshotSoundCooldown() - 1);
            }
            if (this.redstoneCooldown > 0) {
                --this.redstoneCooldown;
            }
            if (this.toggleNightVisionCooldown > 0) {
                --this.toggleNightVisionCooldown;
            }
        } else if (this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_177230_c() != SCContent.securityCamera) {
            this.func_70106_y();
        }
    }

    public void toggleRedstonePowerFromClient() {
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (((IModuleInventory)this.field_70170_p.func_175625_s(pos)).isModuleEnabled(ModuleType.REDSTONE)) {
            SecurityCraft.network.sendToServer((IMessage)new SetCameraPowered(pos, (Boolean)this.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)SecurityCameraBlock.POWERED) == false));
        }
    }

    public void toggleNightVisionFromClient() {
        this.toggleNightVisionCooldown = 30;
        SecurityCraft.network.sendToServer((IMessage)new ToggleNightVision());
    }

    public float getZoomAmount() {
        return this.zoomAmount;
    }

    public boolean isCameraDown() {
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        return this.field_70170_p.func_175625_s(pos) instanceof SecurityCameraBlockEntity && ((SecurityCameraBlockEntity)this.field_70170_p.func_175625_s(pos)).isDown();
    }

    protected void func_70101_b(float yaw, float pitch) {
        super.func_70101_b(yaw, pitch);
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.discardCamera();
    }

    public void stopViewing(EntityPlayerMP player) {
        if (!this.field_70170_p.field_72995_K) {
            WorldServer serverWorld = (WorldServer)this.field_70170_p;
            BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Chunk chunk = serverWorld.func_175726_f(pos);
            ChunkPos chunkPos = chunk.func_76632_l();
            ChunkPos playerChunkPos = new ChunkPos(player.func_180425_c());
            int viewDistance = player.field_71133_b.func_184103_al().func_72395_o();
            for (int cx = chunkPos.field_77276_a - viewDistance; cx <= chunkPos.field_77276_a + viewDistance; ++cx) {
                for (int cz = chunkPos.field_77275_b - viewDistance; cz <= chunkPos.field_77275_b + viewDistance; ++cz) {
                    if (cx >= playerChunkPos.field_77276_a - viewDistance && cx <= playerChunkPos.field_77276_a + viewDistance && cz >= playerChunkPos.field_77275_b - viewDistance && cz <= playerChunkPos.field_77275_b + viewDistance) continue;
                    serverWorld.func_184164_w().func_187302_c(cx, cz).func_187277_b(player);
                }
            }
            serverWorld.func_184164_w().func_72683_a(player);
            player.field_175401_bS = player;
            SecurityCraft.network.sendTo((IMessage)new SetCameraView((Entity)player), player);
            for (EntityTrackerEntry entry : serverWorld.func_73039_n().field_72793_b) {
                if (entry.func_187260_b() == player) continue;
                entry.field_73134_o.remove(player);
                entry.func_73117_b(player);
            }
            this.func_70106_y();
            if (player.func_70660_b(MobEffects.field_76439_r) instanceof CameraNightVisionEffectInstance) {
                player.func_184589_d(MobEffects.field_76439_r);
            }
        }
    }

    @Deprecated
    public void discardCamera() {
        if (!this.field_70170_p.field_72995_K) {
            TileEntity te = this.field_70170_p.func_175625_s(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v));
            if (te instanceof SecurityCameraBlockEntity) {
                ((SecurityCameraBlockEntity)te).stopViewing();
            }
            if (this.chunkTicket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
                this.chunkTicket = null;
            }
        }
    }

    public void setChunkTicket(ForgeChunkManager.Ticket chunkTicket) {
        this.chunkTicket = chunkTicket;
    }

    @Override
    public void shutDown() {
        this.func_184226_ay();
        this.func_70106_y();
    }

    @Override
    public boolean isShutDown() {
        return false;
    }

    @Override
    public void setShutDown(boolean shutDown) {
    }

    protected void func_70088_a() {
    }

    public void func_70014_b(NBTTagCompound tag) {
    }

    public void func_70037_a(NBTTagCompound tag) {
    }

    public int getScreenshotSoundCooldown() {
        return this.screenshotSoundCooldown;
    }

    public void setScreenshotSoundCooldown(int screenshotSoundCooldown) {
        this.screenshotSoundCooldown = screenshotSoundCooldown;
    }
}

