/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncRiftStabilizer
implements IMessage {
    private BlockPos pos;
    private RiftStabilizerBlockEntity.TeleportationType teleportationType;
    private boolean allowed;

    public SyncRiftStabilizer() {
    }

    public SyncRiftStabilizer(BlockPos pos, RiftStabilizerBlockEntity.TeleportationType teleportationType, boolean allowed) {
        this.pos = pos;
        this.teleportationType = teleportationType;
        this.allowed = allowed;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.teleportationType = RiftStabilizerBlockEntity.TeleportationType.values()[buf.readInt()];
        this.allowed = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.teleportationType.ordinal());
        buf.writeBoolean(this.allowed);
    }

    public static class Handler
    implements IMessageHandler<SyncRiftStabilizer, IMessage> {
        public IMessage onMessage(SyncRiftStabilizer message, MessageContext ctx) {
            LevelUtils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                RiftStabilizerBlockEntity te;
                World world;
                if (message.teleportationType != null && (world = ctx.getServerHandler().field_147369_b.field_70170_p).func_175625_s(message.pos) instanceof RiftStabilizerBlockEntity && (te = (RiftStabilizerBlockEntity)world.func_175625_s(message.pos)).isOwnedBy((EntityPlayer)ctx.getServerHandler().field_147369_b)) {
                    IBlockState state = world.func_180495_p(message.pos);
                    te.setFilter(message.teleportationType, message.allowed);
                    world.func_184138_a(message.pos, state, state, 2);
                }
            });
            return null;
        }
    }
}

