/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class SecurityCameraRenderer
extends TileEntitySpecialRenderer<SecurityCameraBlockEntity> {
    private static final SecurityCameraModel MODEL = new SecurityCameraModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/blocks/security_camera.png");
    private static final ResourceLocation BEING_VIEWED_TEXTURE = new ResourceLocation("securitycraft:textures/blocks/security_camera_viewing.png");

    public void render(SecurityCameraBlockEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState state;
        if (te.isDown() || PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().func_175606_aa().func_180425_c().func_177977_b().equals((Object)te.func_174877_v())) {
            return;
        }
        float rotation = -10000.0f;
        if (te.func_145830_o()) {
            Tessellator tessellator = Tessellator.func_178181_a();
            float brightness = te.func_145831_w().func_175724_o(te.func_174877_v());
            int skyBrightness = te.func_145831_w().func_175626_b(te.func_174877_v(), 0);
            int lightmapX = skyBrightness % 65536;
            int lightmapY = skyBrightness / 65536;
            tessellator.func_178180_c().putColorRGBA(0, (int)(brightness * 255.0f), (int)(brightness * 255.0f), (int)(brightness * 255.0f), 255);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapX, (float)lightmapY);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(te.isSomeoneViewing() ? BEING_VIEWED_TEXTURE : TEXTURE);
        GlStateManager.func_179094_E();
        if (te.func_145830_o() && (state = te.func_145831_w().func_180495_p(te.func_174877_v())).func_177230_c() == SCContent.securityCamera) {
            EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)SecurityCameraBlock.FACING);
            if (side == EnumFacing.EAST) {
                rotation = -1.0f;
            } else if (side == EnumFacing.WEST) {
                rotation = 1.0f;
            } else if (side == EnumFacing.NORTH) {
                rotation = 0.0f;
            }
        }
        GlStateManager.func_179114_b((float)180.0f, (float)rotation, (float)0.0f, (float)1.0f);
        if (!te.isDisabled()) {
            SecurityCameraRenderer.MODEL.cameraRotationPoint.field_78796_g = (float)ClientUtils.lerp((double)partialTicks, te.getOriginalCameraRotation(), te.getCameraRotation());
        }
        SecurityCameraRenderer.MODEL.cameraRotationPoint.field_78795_f = te.isShutDown() ? 0.9f : 0.2617994f;
        MODEL.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

