/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.SetKeycardUses;
import net.geforcemods.securitycraft.network.server.SyncKeycardSettings;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.screen.components.StringHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeycardReaderScreen
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/keycard_reader.png");
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private static final ResourceLocation RANDOM_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/random.png");
    private static final ResourceLocation RANDOM_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/random_inactive.png");
    private static final ResourceLocation RESET_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/reset.png");
    private static final ResourceLocation RESET_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/reset_inactive.png");
    private static final ResourceLocation RETURN_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/return.png");
    private static final ResourceLocation RETURN_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/return_inactive.png");
    private static final ResourceLocation WORLD_SELECTION_ICONS = new ResourceLocation("textures/gui/world_selection.png");
    private static final String EQUALS = "=";
    private static final String GREATER_THAN_EQUALS = ">=";
    private static final int MAX_SIGNATURE = 99999;
    private final String title;
    private final String inventoryText = Utils.localize("container.inventory", new Object[0]).func_150254_d();
    private final String keycardLevelsText = Utils.localize("gui.securitycraft:keycard_reader.keycard_levels", new Object[0]).func_150254_d();
    private final String linkText = Utils.localize("gui.securitycraft:keycard_reader.link", new Object[0]).func_150254_d();
    private final String levelMismatchInfo = Utils.localize("gui.securitycraft:keycard_reader.level_mismatch", new Object[0]).func_150254_d();
    private final String limitedInfo = Utils.localize("tooltip.securitycraft:keycard.limited_info", new Object[0]).func_150254_d();
    private String smartModuleTooltip;
    private final KeycardReaderBlockEntity te;
    private final boolean hasSmartModule;
    private final boolean isOwner;
    private boolean isExactLevel = true;
    private int previousSignature;
    private int signature;
    private boolean[] acceptedLevels;
    private String signatureText;
    private int signatureTextLength;
    private int signatureTextStartX;
    private GuiButton minusThree;
    private GuiButton minusTwo;
    private GuiButton minusOne;
    private GuiButton reset;
    private GuiButton plusOne;
    private GuiButton plusTwo;
    private GuiButton plusThree;
    private TogglePictureButton[] toggleButtons = new TogglePictureButton[5];
    private GuiTextField usesTextField;
    private StringHoverChecker usesHoverChecker;
    private StringHoverChecker randomizeHoverChecker;
    private GuiButton setUsesButton;
    private GuiButton linkButton;
    private boolean firstTick = true;
    private KeycardReaderMenu container = (KeycardReaderMenu)this.field_147002_h;

    public KeycardReaderScreen(InventoryPlayer inv, KeycardReaderBlockEntity tile) {
        super((Container)new KeycardReaderMenu(inv, tile));
        this.te = tile;
        this.signature = this.previousSignature = MathHelper.func_76125_a((int)this.te.getSignature(), (int)0, (int)99999);
        this.acceptedLevels = this.te.getAcceptedLevels();
        this.hasSmartModule = this.te.isModuleEnabled(ModuleType.SMART);
        this.isOwner = this.te.isOwnedBy(inv.field_70458_d);
        this.field_147000_g = 249;
        this.title = tile.func_145748_c_().func_150254_d();
        this.smartModuleTooltip = this.hasSmartModule ? Utils.localize("gui.securitycraft:keycard_reader.smartModule", new Object[0]).func_150254_d() : Utils.localize("gui.securitycraft:keycard_reader.noSmartModule", new Object[0]).func_150254_d();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int buttonHeight = 13;
        int buttonY = this.field_147009_r + 35;
        int activeButtons = 0;
        int firstActiveButton = -1;
        int id = 0;
        for (int i = 0; i < 5; ++i) {
            this.toggleButtons[i] = (TogglePictureButton)this.func_189646_b((GuiButton)new TogglePictureButton(id++, this.field_147003_i + 100, this.field_147009_r + 50 + (i + 1) * 17, 15, 15, BEACON_GUI, new int[]{110, 88}, new int[]{219, 219}, -1, 17, 17, 21, 22, 256, 256, 2, thisButton -> {
                if (!this.hasSmartModule) {
                    for (int otherButtonId = 0; otherButtonId < 5; ++otherButtonId) {
                        boolean active = this.isExactLevel ? otherButtonId == thisButton.field_146127_k : otherButtonId >= thisButton.field_146127_k;
                        this.changeLevelState(otherButtonId, active);
                    }
                } else {
                    this.acceptedLevels[thisButton.field_146127_k] = !this.acceptedLevels[thisButton.field_146127_k];
                }
            }));
            this.toggleButtons[i].setCurrentIndex(this.acceptedLevels[i] ? 1 : 0);
            this.toggleButtons[i].field_146124_l = this.isOwner;
            if (this.hasSmartModule || !this.acceptedLevels[i]) continue;
            if (firstActiveButton == -1) {
                firstActiveButton = i;
            }
            ++activeButtons;
        }
        this.minusThree = this.func_189646_b((GuiButton)new ClickButton(id++, this.field_147003_i + 22, buttonY, 24, buttonHeight, "---", b -> this.changeSignature(this.signature - 100)));
        this.minusTwo = this.func_189646_b((GuiButton)new ClickButton(id++, this.field_147003_i + 48, buttonY, 18, buttonHeight, "--", b -> this.changeSignature(this.signature - 10)));
        this.minusOne = this.func_189646_b((GuiButton)new ClickButton(id++, this.field_147003_i + 68, buttonY, 12, buttonHeight, "-", b -> this.changeSignature(this.signature - 1)));
        this.reset = this.func_189646_b((GuiButton)new PictureButton(id++, this.field_147003_i + 82, buttonY, 12, buttonHeight, RESET_INACTIVE_TEXTURE, 10, 10, 1, 2, 10, 10, 10, 10, b -> this.changeSignature(this.previousSignature)){

            @Override
            public ResourceLocation getTextureLocation() {
                return this.field_146124_l ? RESET_TEXTURE : RESET_INACTIVE_TEXTURE;
            }
        });
        this.plusOne = this.func_189646_b((GuiButton)new ClickButton(id++, this.field_147003_i + 96, buttonY, 12, buttonHeight, "+", b -> this.changeSignature(this.signature + 1)));
        this.plusTwo = this.func_189646_b((GuiButton)new ClickButton(id++, this.field_147003_i + 110, buttonY, 18, buttonHeight, "++", b -> this.changeSignature(this.signature + 10)));
        this.plusThree = this.func_189646_b((GuiButton)new ClickButton(id++, this.field_147003_i + 130, buttonY, 24, buttonHeight, "+++", b -> this.changeSignature(this.signature + 100)));
        GuiButton randomizeButton = this.func_189646_b((GuiButton)new PictureButton(id++, this.field_147003_i + 156, buttonY, 12, buttonHeight, RANDOM_INACTIVE_TEXTURE, 10, 10, 1, 2, 10, 10, 10, 10, b -> this.changeSignature(this.field_146297_k.field_71441_e.field_73012_v.nextInt(99999))){

            @Override
            public ResourceLocation getTextureLocation() {
                return this.field_146124_l ? RANDOM_TEXTURE : RANDOM_INACTIVE_TEXTURE;
            }
        });
        randomizeButton.field_146124_l = this.isOwner;
        this.changeSignature(this.signature);
        this.linkButton = this.func_189646_b((GuiButton)new ClickButton(id++, this.field_147003_i + 8, this.field_147009_r + 126, 70, 20, this.linkText, b -> {
            this.previousSignature = this.signature;
            this.changeSignature(this.signature);
            SecurityCraft.network.sendToServer((IMessage)new SyncKeycardSettings(this.te.func_174877_v(), this.acceptedLevels, this.signature, true));
            if (this.container.keycardSlot.func_75211_c().func_82833_r().equalsIgnoreCase("Zelda")) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SCSounds.GET_ITEM.event, (float)1.25f));
            }
        }));
        this.linkButton.field_146124_l = false;
        this.setUsesButton = this.func_189646_b((GuiButton)new PictureButton(id++, this.field_147003_i + 62, this.field_147009_r + 106, 16, 17, RETURN_TEXTURE, 14, 14, 2, 2, 14, 14, 14, 14, b -> SecurityCraft.network.sendToServer((IMessage)new SetKeycardUses(this.te.func_174877_v(), Integer.parseInt(this.usesTextField.func_146179_b())))){

            @Override
            public ResourceLocation getTextureLocation() {
                return this.field_146124_l ? RETURN_TEXTURE : RETURN_INACTIVE_TEXTURE;
            }
        });
        this.setUsesButton.field_146124_l = false;
        Keyboard.enableRepeatEvents((boolean)true);
        this.usesTextField = new GuiTextField(id++, this.field_146289_q, this.field_147003_i + 28, this.field_147009_r + 107, 30, 15);
        this.usesTextField.func_146193_g(-1);
        this.usesTextField.func_146204_h(-1);
        this.usesTextField.func_146185_a(true);
        this.usesTextField.func_175205_a(s -> s.matches("\\d*"));
        this.usesTextField.func_146203_f(3);
        this.usesHoverChecker = new StringHoverChecker(this.field_147009_r + 107, this.field_147009_r + 122, this.field_147003_i + 28, this.field_147003_i + 58, this.limitedInfo);
        this.randomizeHoverChecker = new StringHoverChecker(randomizeButton, Utils.localize("gui.securitycraft:keycard_reader.randomize_signature", new Object[0]).func_150254_d());
        if (!this.hasSmartModule) {
            if (activeButtons == 1) {
                this.isExactLevel = true;
            } else if (activeButtons == 0) {
                this.isExactLevel = true;
                this.changeLevelState(0, true);
            } else {
                boolean active = false;
                this.isExactLevel = false;
                for (int i = 0; i < 5; ++i) {
                    if (i == firstActiveButton) {
                        active = true;
                    }
                    this.changeLevelState(i, active);
                }
            }
            ((ClickButton)this.func_189646_b((GuiButton)new ClickButton((int)id++, (int)(this.field_147003_i + 135), (int)(this.field_147009_r + 67), (int)18, (int)18, (String)(this.isExactLevel ? EQUALS : GREATER_THAN_EQUALS), (Consumer<ClickButton>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$initGui$12(net.geforcemods.securitycraft.screen.components.ClickButton ), (Lnet/geforcemods/securitycraft/screen/components/ClickButton;)V)((KeycardReaderScreen)this)))).field_146124_l = this.isOwner;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.title) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.signatureText, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.signatureText) / 2, 23, 0x404040);
        this.field_146289_q.func_78276_b(this.keycardLevelsText, 170 - this.field_146289_q.func_78256_a(this.keycardLevelsText), 56, 0x404040);
        for (int i = 1; i <= 5; ++i) {
            this.field_146289_q.func_78276_b("" + i, 91, 55 + 17 * i, 0x404040);
        }
        this.field_146289_q.func_78276_b(this.inventoryText, 8, this.field_147000_g - 93, 0x404040);
    }

    public void func_73876_c() {
        super.func_73876_c();
        ItemStack stack = this.container.keycardSlot.func_75211_c();
        boolean isEmpty = stack.func_190926_b();
        boolean wasActive = this.usesTextField.field_146226_p;
        boolean hasTag = stack.func_77942_o() && !stack.func_77978_p().func_82582_d();
        boolean enabled = !isEmpty && hasTag && stack.func_77978_p().func_74767_n("limited");
        int cardSignature = hasTag ? stack.func_77978_p().func_74762_e("signature") : -1;
        this.usesTextField.func_146184_c(enabled);
        if (!wasActive && enabled) {
            this.usesTextField.func_146180_a("" + stack.func_77978_p().func_74762_e("uses"));
        } else if (wasActive && !enabled) {
            this.usesTextField.func_146180_a("");
        }
        if (this.firstTick) {
            this.setUsesButton.field_146124_l = false;
            this.linkButton.field_146124_l = false;
            this.firstTick = false;
        } else {
            this.setUsesButton.field_146124_l = enabled && this.usesTextField.func_146179_b() != null && !this.usesTextField.func_146179_b().isEmpty() && !("" + stack.func_77978_p().func_74762_e("uses")).equals(this.usesTextField.func_146179_b());
            this.linkButton.field_146124_l = !isEmpty && cardSignature != this.signature;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.usesTextField.func_146194_f();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack stack = this.container.keycardSlot.func_75211_c();
        if (!stack.func_190926_b() && !this.acceptedLevels[((KeycardItem)stack.func_77973_b()).getLevel()]) {
            int left = this.field_147003_i + 40;
            int top = this.field_147009_r + 60;
            GlStateManager.func_179140_f();
            this.field_146297_k.func_110434_K().func_110577_a(WORLD_SELECTION_ICONS);
            KeycardReaderScreen.func_152125_a((int)left, (int)top, (float)70.0f, (float)37.0f, (int)22, (int)22, (int)22, (int)22, (float)256.0f, (float)256.0f);
            GlStateManager.func_179145_e();
            if (mouseX >= left - 7 && mouseX < left + 13 && mouseY >= top && mouseY <= top + 22) {
                GuiUtils.drawHoveringText(Arrays.asList(this.levelMismatchInfo), (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)this.field_146289_q);
            }
        }
        if (!this.usesTextField.field_146226_p && !stack.func_190926_b() && this.usesHoverChecker.checkHover(mouseX, mouseY)) {
            GuiUtils.drawHoveringText(this.usesHoverChecker.getLines(), (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)this.field_146289_q);
        }
        if (this.randomizeHoverChecker.checkHover(mouseX, mouseY)) {
            GuiUtils.drawHoveringText(this.randomizeHoverChecker.getLines(), (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)this.field_146289_q);
        }
        this.func_191948_b(mouseX, mouseY);
        net.geforcemods.securitycraft.util.GuiUtils.renderModuleInfo(ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.field_147003_i + 5, this.field_147009_r + 5, this.field_146294_l, this.field_146295_m, mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b((this.field_146294_l - this.field_146999_f) / 2, (this.field_146295_m - this.field_147000_g) / 2, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode != 1 && this.usesTextField.func_146206_l()) {
            this.usesTextField.func_146201_a(typedChar, keyCode);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.usesTextField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.isOwner) {
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            if (mouseX >= this.field_147003_i + this.signatureTextStartX && mouseY >= this.field_147009_r + 23 && mouseX <= this.field_147003_i + this.signatureTextStartX + this.signatureTextLength && mouseY <= this.field_147009_r + 43) {
                this.changeSignature(this.signature + (int)Math.signum(Mouse.getEventDWheel()));
            }
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.isOwner) {
            this.te.setAcceptedLevels(this.acceptedLevels);
            this.te.setSignature(this.signature);
            SecurityCraft.network.sendToServer((IMessage)new SyncKeycardSettings(this.te.func_174877_v(), this.acceptedLevels, this.signature, false));
        }
    }

    public void changeSignature(int newSignature) {
        boolean enableMinusButtons;
        if (this.isOwner) {
            this.signature = MathHelper.func_76125_a((int)newSignature, (int)0, (int)99999);
        }
        this.signatureText = new TextComponentTranslation("gui.securitycraft:keycard_reader.signature", new Object[]{StringUtils.leftPad((String)("" + this.signature), (int)5, (String)"0")}).func_150254_d();
        this.signatureTextLength = this.field_146289_q.func_78256_a(this.signatureText);
        this.signatureTextStartX = this.field_146999_f / 2 - this.signatureTextLength / 2;
        boolean enablePlusButtons = this.isOwner && this.signature != 99999;
        this.minusThree.field_146124_l = enableMinusButtons = this.isOwner && this.signature != 0;
        this.minusTwo.field_146124_l = enableMinusButtons;
        this.minusOne.field_146124_l = enableMinusButtons;
        this.reset.field_146124_l = this.isOwner && this.signature != this.previousSignature;
        this.plusOne.field_146124_l = enablePlusButtons;
        this.plusTwo.field_146124_l = enablePlusButtons;
        this.plusThree.field_146124_l = enablePlusButtons;
    }

    public void changeLevelState(int i, boolean active) {
        if (this.isOwner) {
            this.toggleButtons[i].setCurrentIndex(active ? 1 : 0);
            this.acceptedLevels[i] = active;
        }
    }

    private /* synthetic */ void lambda$initGui$12(ClickButton b) {
        boolean change = false;
        this.isExactLevel = !this.isExactLevel;
        for (int i = 0; i < 5; ++i) {
            if (change) {
                this.changeLevelState(i, !this.isExactLevel);
                continue;
            }
            change = this.acceptedLevels[i];
        }
        b.field_146126_j = this.isExactLevel ? EQUALS : GREATER_THAN_EQUALS;
    }
}

