/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.inventory.GenericMenu;
import net.geforcemods.securitycraft.network.server.SyncSSSSettingsOnServer;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.SSSConnectionList;
import net.geforcemods.securitycraft.screen.components.StringHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.BlockNote;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class SonicSecuritySystemScreen
extends GuiContainer
implements SSSConnectionList.ConnectionAccessor {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/sonic_security_system.png");
    private static final ResourceLocation STREAMER_ICONS = new ResourceLocation("textures/gui/stream_indicator.png");
    private static final TextComponentTranslation SOUND_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.sound", new Object[0]);
    private static final int PLAYBACK_DELAY = 10;
    private final SonicSecuritySystemBlockEntity te;
    private ClickButton recordingButton;
    private ClickButton clearButton;
    private ClickButton powerButton;
    private ClickButton playButton;
    private ClickButton invertButton;
    private StringHoverChecker invertButtonHoverChecker;
    private TogglePictureButton soundButton;
    private SSSConnectionList<SonicSecuritySystemScreen> connectionList;
    private boolean playback = false;
    private int tickCount = 10;
    private int currentNote = 0;
    private boolean isOwner;
    private String title;

    public SonicSecuritySystemScreen(SonicSecuritySystemBlockEntity te) {
        super((Container)new GenericMenu(te));
        this.te = te;
        this.title = te.func_145748_c_().func_150254_d();
        this.isOwner = te.isOwnedBy((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        this.field_146999_f = 300;
    }

    public void func_73876_c() {
        if (this.playback) {
            ++this.tickCount;
            if (this.tickCount >= 10) {
                if (this.currentNote < this.te.getNumberOfNotes()) {
                    SonicSecuritySystemBlockEntity.NoteWrapper note = this.te.getRecordedNotes().get(this.currentNote++);
                    SoundEvent sound = ((BlockNote)Blocks.field_150323_B).func_185576_e(NoteBlockEvent.Instrument.valueOf((String)note.instrumentName.toUpperCase()).ordinal());
                    float pitch = (float)Math.pow(2.0, (double)(note.noteID - 12) / 12.0);
                    this.tickCount = 0;
                    this.field_146297_k.field_71441_e.func_184133_a((EntityPlayer)this.field_146297_k.field_71439_g, this.te.func_174877_v(), sound, SoundCategory.RECORDS, 3.0f, pitch);
                } else if (this.currentNote >= this.te.getNumberOfNotes()) {
                    this.currentNote = 0;
                    this.playback = false;
                }
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        boolean isActive = this.te.isActive();
        boolean hasNotes = this.te.getNumberOfNotes() > 0;
        int leftPos = (this.field_146294_l - this.field_146999_f) / 2;
        int buttonX = leftPos + this.field_146999_f - 155;
        this.powerButton = (ClickButton)this.func_189646_b((GuiButton)new ClickButton(0, buttonX, this.field_146295_m / 2 - 59, 150, 20, this.getPowerString(this.te.isActive()), button -> {
            boolean toggledState = !this.te.isActive();
            boolean containsNotes = this.te.getNumberOfNotes() > 0;
            this.te.setActive(toggledState);
            SecurityCraft.network.sendToServer((IMessage)new SyncSSSSettingsOnServer(this.te.func_174877_v(), toggledState ? SyncSSSSettingsOnServer.DataType.POWER_ON : SyncSSSSettingsOnServer.DataType.POWER_OFF));
            this.powerButton.field_146126_j = this.getPowerString(toggledState);
            if (!toggledState) {
                this.recordingButton.field_146126_j = this.getRecordingString(false);
            }
            this.recordingButton.field_146124_l = toggledState;
            this.soundButton.field_146124_l = toggledState;
            this.playButton.field_146124_l = toggledState && containsNotes;
            this.clearButton.field_146124_l = toggledState && containsNotes;
        }));
        this.recordingButton = (ClickButton)this.func_189646_b((GuiButton)new ClickButton(1, buttonX, this.field_146295_m / 2 - 37, 150, 20, this.getRecordingString(this.te.isRecording()), button -> {
            boolean recording = !this.te.isRecording();
            this.te.setRecording(recording);
            SecurityCraft.network.sendToServer((IMessage)new SyncSSSSettingsOnServer(this.te.func_174877_v(), recording ? SyncSSSSettingsOnServer.DataType.RECORDING_ON : SyncSSSSettingsOnServer.DataType.RECORDING_OFF));
            this.recordingButton.field_146126_j = this.getRecordingString(this.te.isRecording());
        }));
        this.playButton = (ClickButton)this.func_189646_b((GuiButton)new ClickButton(2, buttonX, this.field_146295_m / 2 - 15, 150, 20, Utils.localize("gui.securitycraft:sonic_security_system.recording.play", new Object[0]).func_150254_d(), button -> {
            if (this.te.getNumberOfNotes() > 0) {
                this.playback = true;
            }
        }));
        this.clearButton = (ClickButton)this.func_189646_b((GuiButton)new ClickButton(3, buttonX, this.field_146295_m / 2 + 7, 150, 20, Utils.localize("gui.securitycraft:sonic_security_system.recording.clear", new Object[0]).func_150254_d(), button -> {
            this.te.clearNotes();
            SecurityCraft.network.sendToServer((IMessage)new SyncSSSSettingsOnServer(this.te.func_174877_v(), SyncSSSSettingsOnServer.DataType.CLEAR_NOTES));
            this.playButton.field_146124_l = false;
            this.clearButton.field_146124_l = false;
        }));
        this.invertButton = (ClickButton)this.func_189646_b((GuiButton)new ClickButton(4, buttonX, this.field_146295_m / 2 + 29, 150, 20, Utils.localize("gui.securitycraft:sonic_security_system.invert_functionality", new Object[0]).func_150254_d(), button -> {
            this.te.setDisableBlocksWhenTuneIsPlayed(!this.te.disablesBlocksWhenTuneIsPlayed());
            this.updateInvertButtonTooltip();
            SecurityCraft.network.sendToServer((IMessage)new SyncSSSSettingsOnServer(this.te.func_174877_v(), SyncSSSSettingsOnServer.DataType.INVERT_FUNCTIONALITY));
        }));
        this.updateInvertButtonTooltip();
        this.soundButton = (TogglePictureButton)this.func_189646_b((GuiButton)new TogglePictureButton(5, buttonX + 130, this.field_146295_m / 2 + 52, 20, 20, STREAMER_ICONS, new int[]{0, 0}, new int[]{32, 48}, 2, 16, 16, 16, 16, 16, 64, 2, button -> {
            boolean toggledPing = !this.te.pings();
            this.te.setPings(toggledPing);
            SecurityCraft.network.sendToServer((IMessage)new SyncSSSSettingsOnServer(this.te.func_174877_v(), toggledPing ? SyncSSSSettingsOnServer.DataType.SOUND_ON : SyncSSSSettingsOnServer.DataType.SOUND_OFF));
        }));
        this.soundButton.setCurrentIndex(!this.te.pings() ? 1 : 0);
        this.connectionList = new SSSConnectionList<SonicSecuritySystemScreen>(this, this.field_146297_k, 130, 120, this.powerButton.field_146129_i, leftPos + 10);
        this.powerButton.field_146124_l = isActive && this.isOwner;
        this.recordingButton.field_146124_l = isActive && this.isOwner;
        this.soundButton.field_146124_l = isActive && this.isOwner;
        this.playButton.field_146124_l = isActive && hasNotes;
        this.clearButton.field_146124_l = isActive && hasNotes && this.isOwner;
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String soundText = SOUND_TEXT.func_150254_d();
        int textWidth = this.field_146289_q.func_78256_a(this.title);
        int soundTextLength = this.field_146289_q.func_78256_a(soundText);
        this.field_146289_q.func_78276_b(this.title, this.field_146999_f / 2 - textWidth / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(soundText, -this.field_147003_i + this.soundButton.field_146128_h - soundTextLength - 5, 141, 0x404040);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        if (this.connectionList != null) {
            this.connectionList.drawScreen(mouseX, mouseY);
        }
        if (this.invertButtonHoverChecker.checkHover(mouseX, mouseY)) {
            GuiUtils.drawHoveringText(this.invertButtonHoverChecker.getLines(), (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)this.field_146289_q);
        }
    }

    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        SonicSecuritySystemScreen.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)512.0f, (float)512.0f);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.connectionList.handleMouseInput(mouseX, mouseY);
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    public Set<BlockPos> getPositions() {
        if (this.isOwner) {
            return this.te.getLinkedBlocks();
        }
        return new HashSet<BlockPos>();
    }

    @Override
    public void removePosition(BlockPos pos) {
        this.te.delink(pos, true);
        this.connectionList.refreshPositions();
        SecurityCraft.network.sendToServer((IMessage)new SyncSSSSettingsOnServer(this.te.func_174877_v(), SyncSSSSettingsOnServer.DataType.REMOVE_POS, pos));
    }

    private String getRecordingString(boolean recording) {
        return (recording ? Utils.localize("gui.securitycraft:sonic_security_system.stop_recording", new Object[0]) : Utils.localize("gui.securitycraft:sonic_security_system.start_recording", new Object[0])).func_150254_d();
    }

    private String getPowerString(boolean on) {
        return (on ? Utils.localize("gui.securitycraft:sonic_security_system.power.on", new Object[0]) : Utils.localize("gui.securitycraft:sonic_security_system.power.off", new Object[0])).func_150254_d();
    }

    private void updateInvertButtonTooltip() {
        this.invertButtonHoverChecker = new StringHoverChecker((GuiButton)this.invertButton, Utils.localize("gui.securitycraft:sonic_security_system.invert.tooltip_" + (this.te.disablesBlocksWhenTuneIsPlayed() ? "inverted" : "default"), new Object[0]).func_150254_d());
    }
}

