/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IThreadListener;

public class PasscodeUtils {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static HashingThread hashingThread;

    private PasscodeUtils() {
    }

    public static void startHashingThread(IThreadListener executor) {
        if (hashingThread == null) {
            hashingThread = new HashingThread(executor);
            hashingThread.start();
        }
    }

    public static void stopHashingThread() {
        if (hashingThread != null) {
            hashingThread.interrupt();
            hashingThread = null;
        }
    }

    public static NBTTagCompound filterPasscodeAndSaltFromTag(NBTTagCompound tag) {
        tag.func_82580_o("passcode");
        tag.func_82580_o("saltKeyMost");
        tag.func_82580_o("saltKeyLeast");
        return tag;
    }

    public static String hashPasscodeWithoutSalt(String original) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            return PasscodeUtils.bytesToString(md.digest(original.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void hashPasscode(String passcode, byte[] salt, Consumer<byte[]> afterHashing) {
        if (passcode != null && salt != null) {
            hashingThread.workList.addLast(new HashingWork(passcode, salt, afterHashing));
        }
    }

    public static String bytesToString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte currentByte : bytes) {
            sb.append(Integer.toString((currentByte & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static byte[] stringToBytes(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        byte[] bytes = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            int index = i * 2;
            int parsedInt = Integer.parseInt(string.substring(index, index + 2), 16);
            bytes[i] = (byte)parsedInt;
        }
        return bytes;
    }

    public static byte[] generateSalt() {
        byte[] salt = new byte[16];
        SECURE_RANDOM.nextBytes(salt);
        return salt;
    }

    private static class HashingWork {
        private final String passcode;
        private final byte[] salt;
        private final Consumer<byte[]> afterHashing;

        private HashingWork(String passcode, byte[] salt, Consumer<byte[]> afterHashing) {
            this.passcode = passcode;
            this.salt = salt;
            this.afterHashing = afterHashing;
        }
    }

    private static class HashingThread
    extends Thread {
        private double sleepOverhead = 0.0;
        private final ConcurrentLinkedDeque<HashingWork> workList = new ConcurrentLinkedDeque();
        private final IThreadListener mainExecutor;

        private HashingThread(IThreadListener mainExecutor) {
            this.mainExecutor = mainExecutor;
            this.setDaemon(true);
            this.setName("SecurityCraft Passcode Hashing");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    long start = System.nanoTime();
                    if (!this.workList.isEmpty()) {
                        HashingWork work = this.workList.pop();
                        byte[] hash = HashingThread.hashPasscode(work.passcode, work.salt);
                        this.mainExecutor.func_152344_a(() -> work.afterHashing.accept(hash));
                    }
                    double d = (double)(System.nanoTime() - start) / 1000000.0 + this.sleepOverhead;
                    long sleepTime = 10L - (long)d;
                    this.sleepOverhead = d % 1.0;
                    if (sleepTime <= 0L) continue;
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }

        private static byte[] hashPasscode(String passcode, byte[] salt) {
            try {
                PBEKeySpec spec = new PBEKeySpec(passcode.toCharArray(), salt, 65536, 128);
                SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                return factory.generateSecret(spec).getEncoded();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

