/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.world.generation;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class OreGeneration
implements IWorldGenerator {
    public static final List<Item> MINERABLE_ORES = new ArrayList<Item>();
    public static final List<Item> DEEP_VEIN_ORES = new ArrayList<Item>();
    public static Map<ChunkPos, ItemStack> CHUNKS_VEIN = new ConcurrentHashMap<ChunkPos, ItemStack>();

    private static void generateOverworld(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    public static void init() {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> wListedNames = new ArrayList<String>();
        for (String name : OreDictionary.getOreNames()) {
            if (!name.startsWith("ore") || IRConfig.isOreBlacklisted(name)) continue;
            names.add(name);
        }
        for (String name : names) {
            NonNullList ores = OreDictionary.getOres((String)name);
            for (ItemStack ore : ores) {
                if (ore.func_190926_b() || MINERABLE_ORES.contains(ore.func_77973_b())) continue;
                MINERABLE_ORES.add(ore.func_77973_b());
                wListedNames.add(ore.func_82833_r());
            }
        }
        IndustrialRenewal.LOGGER.info(TextFormatting.GREEN + "Industrial Renewal" + " Minerable ore list: " + wListedNames);
        OreGeneration.populateDeepVeinOres();
    }

    public static ItemStack getChunkVein(World world, BlockPos pos) {
        ChunkPos cPos = world.func_175726_f(pos).func_76632_l();
        ItemStack stack = CHUNKS_VEIN.get(cPos);
        return stack != null ? stack : ItemStack.field_190927_a;
    }

    public static ItemStack generateNewVein(World world) {
        if (!IRConfig.MainConfig.Generation.spawnDeepVein || DEEP_VEIN_ORES.size() <= 0) {
            return ItemStack.field_190927_a;
        }
        int chance = IRConfig.MainConfig.Generation.deepVeinSpawnRate;
        if (world.field_73012_v.nextInt(100) < chance) {
            ItemStack stack = ItemStack.field_190927_a;
            while (stack.func_190926_b()) {
                stack = OreGeneration.getNewStack(world);
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack getNewStack(World world) {
        int min = IRConfig.MainConfig.Generation.deepVeinMinOre;
        int oreQuantity = world.field_73012_v.nextInt(IRConfig.MainConfig.Generation.deepVeinMaxOre - min) + min;
        Item item = DEEP_VEIN_ORES.get(world.field_73012_v.nextInt(DEEP_VEIN_ORES.size() - 1));
        Block block = Block.func_149634_a((Item)item);
        ItemStack stack = new ItemStack(block.func_180660_a(block.func_176223_P(), world.field_73012_v, 0), 1, block.func_180651_a(block.func_176223_P()));
        stack.func_190920_e(oreQuantity);
        return stack;
    }

    private static void populateDeepVeinOres() {
        Map<String, Integer> map = IRConfig.MainConfig.Generation.deepVeinOres;
        if (map.isEmpty()) {
            return;
        }
        int i = 0;
        for (String str : map.keySet()) {
            ItemStack stack;
            String oreName = "";
            if (OreDictionary.doesOreNameExist((String)str)) {
                NonNullList list = OreDictionary.getOres((String)str);
                if (list.isEmpty()) {
                    IndustrialRenewal.LOGGER.warn(TextFormatting.YELLOW + "Oredict not found for: " + str + " , this ore will not be generate in Deep Veins");
                    continue;
                }
                stack = ((ItemStack)list.get(0)).func_77946_l();
                if (str.equals("oreIron")) {
                    stack = new ItemStack((Block)ModBlocks.veinHematite);
                }
                if (!stack.func_190926_b() && !DEEP_VEIN_ORES.contains(stack.func_77973_b())) {
                    oreName = stack.func_82833_r() + " by oredict 1 from " + list.size() + " found";
                    if (list.size() > 1) {
                        oreName = oreName + " list: " + list;
                    }
                    OreGeneration.placeItemXTimes(stack.func_77973_b(), map.get(str));
                    ++i;
                }
            } else {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(str));
                if (item != null && !DEEP_VEIN_ORES.contains(item) && item != Items.field_190931_a) {
                    stack = new ItemStack(item);
                    oreName = stack.func_82833_r() + " by Item: (" + item.getRegistryName() + ")";
                    OreGeneration.placeItemXTimes(item, map.get(str));
                    ++i;
                } else if (item == null || item == Items.field_190931_a) {
                    IndustrialRenewal.LOGGER.warn(TextFormatting.YELLOW + "Item not found for: " + str + " , this ore will not be generate in Deep Veins");
                }
            }
            if (oreName.equals("")) continue;
            IndustrialRenewal.LOGGER.info(TextFormatting.GREEN + "Industrial Renewal" + " Mapped config: " + str + " into: " + oreName);
        }
        IndustrialRenewal.LOGGER.info(TextFormatting.GREEN + "Industrial Renewal" + " Registered in total " + i + " DeepVein Variants");
    }

    private static void placeItemXTimes(Item item, int t) {
        for (int i = 0; i < t; ++i) {
            DEEP_VEIN_ORES.add(item);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            // empty if block
        }
    }
}

