/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component.page;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import openmods.gui.component.GuiComponentItemStack;
import openmods.gui.component.page.PageBase;
import openmods.gui.listener.IMouseDownListener;

public class ItemStackTocPage
extends PageBase {
    private int count;
    private int row;
    private int column;
    private final int columns;
    private final int capacity;
    private final int spacerWidth;
    private final int spacerHeight;
    private final float iconScale;
    private final int iconSize;

    public ItemStackTocPage(int rows, int columns, float iconScale) {
        this.capacity = rows * columns;
        this.iconScale = iconScale;
        this.iconSize = MathHelper.func_76141_d((float)(16.0f * iconScale));
        this.columns = columns;
        int requiredWidth = this.iconSize * columns;
        int requiredHeight = this.iconSize * rows;
        int leftoverWidth = this.getWidth() - requiredWidth;
        int leftoverHeight = this.getHeight() - requiredHeight;
        this.spacerWidth = leftoverWidth / (columns - 1);
        this.spacerHeight = leftoverHeight / (rows - 1);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean addEntry(@Nonnull ItemStack stack, IMouseDownListener clickListener) {
        if (this.count >= this.capacity) {
            return false;
        }
        int x = this.column * (this.iconSize + this.spacerWidth);
        int y = this.row * (this.iconSize + this.spacerHeight);
        GuiComponentItemStack component = new GuiComponentItemStack(x, y, stack, true, this.iconScale);
        component.setListener(clickListener);
        this.addComponent(component);
        if (++this.column >= this.columns) {
            this.column = 0;
            ++this.row;
        }
        ++this.count;
        return true;
    }
}

