/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.ResourceAggregator;
import com.supermartijn642.core.util.Pair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.SimpleResource;
import net.minecraft.util.ResourceLocation;

public abstract class ResourceCache {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public abstract boolean doesResourceExist(ResourceType var1, String var2, String var3, String var4, String var5);

    public abstract void trackToBeGeneratedResource(ResourceType var1, String var2, String var3, String var4, String var5);

    public abstract void saveResource(ResourceType var1, byte[] var2, String var3, String var4, String var5, String var6);

    public abstract <T> void saveResource(ResourceType var1, ResourceAggregator<?, T> var2, T var3, String var4, String var5, String var6, String var7);

    public void saveJsonResource(ResourceType resourceType, JsonObject json, String namespace, String directory, String fileName) {
        byte[] bytes = GSON.toJson((JsonElement)json).getBytes(StandardCharsets.UTF_8);
        this.saveResource(resourceType, bytes, namespace, directory, fileName, fileName.endsWith(".json") ? "" : ".json");
    }

    public abstract Optional<InputStream> getExistingResource(ResourceType var1, String var2, String var3, String var4, String var5);

    static ResourceCache create(Path outputDirectory, Path manualDirectory) {
        return new Impl(outputDirectory, manualDirectory);
    }

    static class Impl
    extends ResourceCache {
        private final Map<Path, HashCode> presentFiles = new HashMap<Path, HashCode>();
        private final Map<Path, HashCode> writtenFiles = new HashMap<Path, HashCode>();
        private final Map<Path, Pair<ResourceAggregator<Object, Object>, Object>> aggregatedResources = new HashMap<Path, Pair<ResourceAggregator<Object, Object>, Object>>();
        private final Set<Path> toBeGenerated = new HashSet<Path>();
        private final Path outputDirectory;
        private final Path manualDirectory;
        private final File cacheFile;
        private boolean allowWrites = true;

        private Impl(Path outputFolder, Path manualFolder) {
            if (outputFolder == null) {
                throw new IllegalArgumentException("Output directory must not be null!");
            }
            this.outputDirectory = outputFolder;
            this.manualDirectory = manualFolder;
            this.cacheFile = outputFolder.resolve(".cache/cache").toFile();
            this.loadCacheFromFile();
        }

        private void loadCacheFromFile() {
            Throwable throwable;
            if (!this.cacheFile.exists()) {
                return;
            }
            try {
                throwable = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(this.cacheFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String[] parts = line.split(" ");
                        if (parts.length > 2) continue;
                        this.presentFiles.put(Paths.get(parts[0], new String[0]), HashCode.fromString((String)parts[0]));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Encountered an exception whilst trying to read the generator cache file!", e);
            }
            try {
                throwable = null;
                try (Stream<Path> paths = Files.walk(this.outputDirectory, new FileVisitOption[0]);){
                    paths.filter(path -> !this.presentFiles.containsKey(this.outputDirectory.relativize((Path)path))).filter(path -> path.toFile().exists() && path.toFile().isFile() && !"cache".equals(path.toFile().getName())).forEach(path -> {
                        HashCode hashCode;
                        try (InputStream inputStream = Files.newInputStream(path.toFile().toPath(), new OpenOption[0]);){
                            Hasher hasher = Hashing.sha1().newHasher();
                            ByteStreams.copy((InputStream)inputStream, (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
                            hashCode = hasher.hash();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        this.presentFiles.put(this.outputDirectory.relativize((Path)path), hashCode);
                    });
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void writeCacheToFile() {
            if (!this.cacheFile.getParentFile().exists()) {
                this.cacheFile.getParentFile().mkdirs();
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.cacheFile));){
                for (Map.Entry<Path, HashCode> entry : this.writtenFiles.entrySet()) {
                    writer.write(entry.getValue().toString());
                    writer.write(32);
                    writer.write(entry.getKey().toString());
                    writer.newLine();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Encountered an exception whilst trying to write the generator cache file!", e);
            }
        }

        void removeRemnants() {
            this.presentFiles.keySet().stream().filter(((Predicate<Path>)this.writtenFiles::containsKey).negate()).map(path -> this.outputDirectory.resolve((Path)path).toFile()).filter(File::exists).forEach(File::delete);
            ArrayList pathList = new ArrayList();
            try (Stream<Path> paths = Files.walk(this.outputDirectory, new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(pathList::add);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            pathList.sort((a, b) -> Integer.compare(b.toString().length(), a.toString().length()));
            pathList.stream().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> {
                try (DirectoryStream<Path> files = Files.newDirectoryStream(path);){
                    boolean bl = !files.iterator().hasNext();
                    return bl;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).map(Path::toFile).forEach(File::delete);
        }

        private boolean existsInGeneratedFiles(Path path) {
            return this.toBeGenerated.contains(path) || this.writtenFiles.containsKey(path) || this.aggregatedResources.containsKey(path);
        }

        private boolean existsInManualFiles(Path path) {
            return this.manualDirectory != null && Files.exists(this.manualDirectory.resolve(path), new LinkOption[0]);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean existsInLoadedResources(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            IResourceManager resourceManager = ClientUtils.getMinecraft().func_110442_L();
            try (IResource resource = resourceManager.func_110536_a(new ResourceLocation(namespace, directory + "/" + fileName + extension));){
                boolean bl = true;
                return bl;
            }
            catch (FileNotFoundException ignored) {
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private Path constructPath(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            if (!extension.isEmpty() && extension.charAt(0) != '.') {
                extension = '.' + extension;
            }
            return Paths.get(resourceType.getDirectoryName(), namespace, directory, fileName + extension);
        }

        @Override
        public boolean doesResourceExist(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            Path path = this.constructPath(resourceType, namespace, directory, fileName, extension);
            return this.existsInGeneratedFiles(path) || this.existsInManualFiles(path) || this.existsInLoadedResources(resourceType, namespace, directory, fileName, extension);
        }

        @Override
        public void trackToBeGeneratedResource(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            this.toBeGenerated.add(this.constructPath(resourceType, namespace, directory, fileName, extension));
        }

        @Override
        public Optional<InputStream> getExistingResource(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            Path path = this.constructPath(resourceType, namespace, directory, fileName, extension);
            if (Files.exists(this.manualDirectory.resolve(path), new LinkOption[0])) {
                try {
                    return Optional.of(Files.newInputStream(this.manualDirectory.resolve(path), new OpenOption[0]));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            IResourceManager resourceManager = ClientUtils.getMinecraft().func_110442_L();
            try {
                IResource resource = resourceManager.func_110536_a(new ResourceLocation(namespace, directory + "/" + fileName + extension));
                if (resource instanceof SimpleResource && resource.func_110528_c()) {
                    ((SimpleResource)resource).field_110531_d.close();
                }
                return Optional.of(resource.func_110527_b());
            }
            catch (FileNotFoundException resource) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return Optional.empty();
        }

        @Override
        public void saveResource(ResourceType resourceType, byte[] data, String namespace, String directory, String fileName, String extension) {
            if (!this.allowWrites) {
                throw new RuntimeException("Resources cannot be saved during this stage!");
            }
            Path path = this.constructPath(resourceType, namespace, directory, fileName, extension);
            if (this.writtenFiles.containsKey(path) || this.aggregatedResources.containsKey(path)) {
                throw new RuntimeException("Duplicate file '" + path + "'!");
            }
            if (this.existsInManualFiles(path)) {
                throw new RuntimeException("File '" + path + "' clashes with a manually created file!");
            }
            Path fullPath = this.outputDirectory.resolve(path);
            HashCode hashCode = Hashing.sha1().hashBytes(data);
            if (this.presentFiles.containsKey(path) && this.presentFiles.get(path).equals((Object)hashCode) && fullPath.toFile().exists()) {
                this.writtenFiles.put(path, hashCode);
                this.toBeGenerated.remove(path);
                return;
            }
            fullPath.toFile().getParentFile().mkdirs();
            try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                outputStream.write(data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.writtenFiles.put(path, hashCode);
            this.toBeGenerated.remove(path);
        }

        @Override
        public <T> void saveResource(ResourceType resourceType, ResourceAggregator<?, T> aggregator, T data, String namespace, String directory, String fileName, String extension) {
            if (!this.allowWrites) {
                throw new RuntimeException("Resources cannot be saved during this stage!");
            }
            Path path = this.constructPath(resourceType, namespace, directory, fileName, extension);
            if (this.writtenFiles.containsKey(path)) {
                throw new RuntimeException("Duplicate file '" + path + "'!");
            }
            if (this.existsInManualFiles(path)) {
                throw new RuntimeException("File '" + path + "' clashes with a manually created file!");
            }
            Pair<ResourceAggregator<Object, Object>, Object> oldEntry = this.aggregatedResources.get(path);
            if (oldEntry != null && oldEntry.left() != aggregator) {
                throw new RuntimeException("Incompatible aggregators for file '" + path + "': '" + oldEntry.left().getClass() + "' and '" + aggregator.getClass() + "'!");
            }
            Object oldData = oldEntry == null ? aggregator.initialData() : oldEntry.right();
            try {
                oldData = aggregator.combine(oldData, data);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to combine data for file '" + path + "'!", e);
            }
            this.aggregatedResources.put(path, Pair.of(aggregator, oldData));
        }

        public void allowWrites(boolean allow) {
            this.allowWrites = allow;
        }

        public void finish() {
            this.aggregatedResources.forEach((path, pair) -> {
                byte[] bytes;
                ResourceAggregator aggregator = (ResourceAggregator)pair.left();
                Object data = pair.right();
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                    aggregator.write(stream, data);
                    bytes = stream.toByteArray();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Path fullPath = this.outputDirectory.resolve((Path)path);
                HashCode hashCode = Hashing.sha1().hashBytes(bytes);
                if (this.presentFiles.containsKey(path) && this.presentFiles.get(path).equals((Object)hashCode) && fullPath.toFile().exists()) {
                    this.writtenFiles.put((Path)path, hashCode);
                    this.toBeGenerated.remove(path);
                    return;
                }
                fullPath.toFile().getParentFile().mkdirs();
                try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                    outputStream.write(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.writtenFiles.put((Path)path, hashCode);
                this.toBeGenerated.remove(path);
            });
            this.removeRemnants();
            this.writeCacheToFile();
            if (!this.toBeGenerated.isEmpty()) {
                throw new RuntimeException("Some tracked files did not get written: " + this.toBeGenerated.stream().map(Path::toString).map(s -> "'" + s + "'").collect(Collectors.joining(",")));
            }
        }
    }
}

