/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.weather.tracker;

import javax.annotation.Nonnull;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.weather.tracker.SimulationTracker;
import org.orecruncher.dsurround.event.WeatherUpdateEvent;

@SideOnly(value=Side.CLIENT)
public class ServerDrivenTracker
extends SimulationTracker {
    protected int nextRainChange = 0;
    protected float thunderStrength = 0.0f;
    protected int nextThunderChange = 0;

    @Override
    protected String type() {
        return "SERVER";
    }

    @Override
    public int getNextRainChange() {
        return this.nextRainChange;
    }

    @Override
    public float getThunderStrength() {
        return this.thunderStrength;
    }

    @Override
    public int getNextThunderChange() {
        return this.nextThunderChange;
    }

    @Override
    public float getCurrentVolume() {
        return 0.05f + 0.95f * this.intensityLevel;
    }

    @Override
    @Nonnull
    public SoundEvent getCurrentStormSound() {
        return this.intensity.getStormSound();
    }

    @Override
    @Nonnull
    public SoundEvent getCurrentDustSound() {
        return this.intensity.getDustSound();
    }

    public void update(@Nonnull WeatherUpdateEvent event) {
        this.maxIntensityLevel = event.maxRainIntensity;
        this.nextRainChange = event.nextRainChange;
        this.thunderStrength = event.thunderStrength;
        this.nextThunderChange = event.nextThunderChange;
        this.nextThunderEvent = event.nextThunderEvent;
        this.setCurrentIntensity(event.rainIntensity);
    }

    @Override
    public void update() {
    }
}

