/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.GuideManager;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.entry.PageValue;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.GuideText;
import buildcraft.lib.client.guide.ref.GuideGroupSet;
import buildcraft.lib.gui.ISimpleDrawable;
import java.util.List;

public class GuidePartGroup
extends GuidePart {
    public final GuideGroupSet group;
    private final GuideText[] texts;
    private final Object[] values;

    public GuidePartGroup(GuiGuide gui, GuideGroupSet group, GuideGroupSet.GroupDirection direction) {
        super(gui);
        int i;
        this.group = group;
        List<PageValue<?>> groupValues = group.getValues(direction);
        this.values = new Object[groupValues.size()];
        for (i = 0; i < this.values.length; ++i) {
            this.values[i] = groupValues.get((int)i).value;
        }
        this.texts = new GuideText[1 + this.values.length];
        this.texts[0] = new GuideText(gui, group.getTitle(direction));
        i = 1;
        for (PageValue<?> single : groupValues) {
            ISimpleDrawable icon = single.createDrawable();
            int n = i++;
            this.texts[n] = new GuideText(gui, new PageLine(icon, icon, 1, single.title, true, single::getTooltip));
        }
    }

    public int hashCode() {
        return this.group.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GuidePartGroup other = (GuidePartGroup)obj;
        return this.group == other.group;
    }

    @Override
    public void setFontRenderer(IFontRenderer fontRenderer) {
        super.setFontRenderer(fontRenderer);
        for (GuideText text : this.texts) {
            text.setFontRenderer(fontRenderer);
        }
    }

    @Override
    public GuidePart.PagePosition renderIntoArea(int x, int y, int width, int height, GuidePart.PagePosition current, int index) {
        current = current.guaranteeSpace(this.getFontRenderer().getMaxFontHeight() * 4, height);
        for (GuideText text : this.texts) {
            current = text.renderIntoArea(x, y, width, height, current, index);
        }
        return current;
    }

    @Override
    public GuidePart.PagePosition handleMouseClick(int x, int y, int width, int height, GuidePart.PagePosition current, int index, int mouseX, int mouseY) {
        current = current.guaranteeSpace(this.getFontRenderer().getMaxFontHeight() * 4, height);
        for (int i = 0; i < this.texts.length; ++i) {
            Object value;
            GuidePageFactory factory;
            GuideText text = this.texts[i];
            current = text.handleMouseClick(x, y, width, height, current, index, mouseX, mouseY);
            if (!text.wasHovered || current.page != index || i <= 0 || (factory = GuideManager.INSTANCE.getFactoryFor(value = this.values[i - 1])) == null) continue;
            this.gui.openPage(factory.createNew(this.gui));
            return new GuidePart.PagePosition(0x1FFFFFFF, 0);
        }
        return current;
    }
}

