/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.chunk;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.LibBase;
import org.orecruncher.lib.chunk.DirectChunkCache;
import org.orecruncher.lib.chunk.IBlockAccessEx;
import org.orecruncher.lib.chunk.IChunkCache;
import org.orecruncher.lib.chunk.PassThroughChunkCache;

@SideOnly(value=Side.CLIENT)
public final class ClientChunkCache {
    private static IBlockAccessEx INSTANCE;
    private static int range;

    public static IBlockAccessEx instance() {
        if (INSTANCE == null) {
            LibBase.log().warn("Initializing ClientChunkCache on the fly!", new Object[0]);
            INSTANCE = new PassThroughChunkCache();
            MinecraftForge.EVENT_BUS.register(ClientChunkCache.class);
        }
        return INSTANCE;
    }

    public static void initialize(int blockRange, boolean useDirect) {
        INSTANCE = useDirect ? new DirectChunkCache() : new PassThroughChunkCache();
        range = blockRange;
        MinecraftForge.EVENT_BUS.register(ClientChunkCache.class);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void clientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (INSTANCE == null) {
            return;
        }
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.START) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                BlockPos pos = new BlockPos((Vec3i)player.func_180425_c());
                BlockPos min = pos.func_177982_a(-range, -range, -range);
                BlockPos max = pos.func_177982_a(range, range, range);
                ((IChunkCache)((Object)INSTANCE)).update(player.func_130014_f_(), min, max);
            } else {
                ((IChunkCache)((Object)INSTANCE)).clear();
            }
        }
    }

    static {
        range = 34;
    }
}

