/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe;

import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeInput
implements IRecipeInput {
    private final int slot;
    @Nonnull
    private final ItemStack input;
    private final boolean useMeta;
    private final FluidStack fluid;
    private final float multiplier;

    public RecipeInput(@Nonnull ItemStack input) {
        this(input, true);
    }

    public RecipeInput(@Nonnull ItemStack input, boolean useMeta) {
        this(input, useMeta, null, 1.0f, -1);
    }

    public RecipeInput(FluidStack fluid) {
        this(Prep.getEmpty(), false, fluid, 1.0f, -1);
    }

    public RecipeInput(FluidStack fluidStack, float mulitplier) {
        this(Prep.getEmpty(), true, fluidStack, mulitplier, -1);
    }

    public RecipeInput(@Nonnull ItemStack item, boolean useMeta, float multiplier, int slot) {
        this(item, useMeta, null, multiplier, slot);
    }

    protected RecipeInput(@Nonnull ItemStack input, boolean useMeta, FluidStack fluid, float mulitplier, int slot) {
        this.input = input.func_77946_l();
        this.useMeta = useMeta;
        this.fluid = fluid == null ? null : fluid.copy();
        this.multiplier = mulitplier;
        this.slot = slot;
    }

    public RecipeInput(@Nonnull RecipeInput copyFrom) {
        this.input = copyFrom.input.func_77946_l();
        this.fluid = copyFrom.fluid == null ? null : copyFrom.fluid.copy();
        this.useMeta = copyFrom.useMeta;
        this.multiplier = copyFrom.multiplier;
        this.slot = copyFrom.slot;
    }

    @Override
    @Nonnull
    public RecipeInput copy() {
        return new RecipeInput(this);
    }

    @Override
    public boolean isFluid() {
        return this.fluid != null;
    }

    @Override
    @Nonnull
    public ItemStack getInput() {
        return this.input.func_77946_l();
    }

    @Override
    public FluidStack getFluidInput() {
        return this.fluid;
    }

    @Override
    public float getMulitplier() {
        return this.multiplier;
    }

    @Override
    public int getSlotNumber() {
        return this.slot;
    }

    @Override
    public boolean isInput(@Nonnull ItemStack test) {
        if (Prep.isInvalid(test) || Prep.isInvalid(this.input)) {
            return false;
        }
        if (this.useMeta) {
            return ItemStack.func_179545_c((ItemStack)this.input, (ItemStack)test) && (!this.input.func_77942_o() || ItemStack.func_77970_a((ItemStack)this.input, (ItemStack)test));
        }
        return test.func_77973_b() == this.input.func_77973_b() && (!this.input.func_77942_o() || ItemStack.func_77970_a((ItemStack)this.input, (ItemStack)test));
    }

    @Override
    public boolean isInput(FluidStack test) {
        if (test == null || this.fluid == null) {
            return false;
        }
        return test.isFluidEqual(this.fluid);
    }

    @Override
    public ItemStack[] getEquivelentInputs() {
        if (Prep.isInvalid(this.input)) {
            return null;
        }
        if (this.useMeta) {
            return new ItemStack[]{this.input};
        }
        ItemStack result = this.input.func_77946_l();
        result.func_77964_b(Short.MAX_VALUE);
        return new ItemStack[]{result};
    }

    public String toString() {
        if (this.isValid()) {
            return "RecipeInput [input=" + this.input + ", useMeta=" + this.useMeta + "]";
        }
        return "RecipeInput invalid";
    }

    @Override
    public boolean isValid() {
        return this.fluid != null && this.fluid.getFluid() != null || Prep.isValid(this.input);
    }

    @Override
    public void shrinkStack(int count) {
        this.input.func_190918_g(count);
    }

    @Override
    public int getStackSize() {
        return this.input.func_190916_E();
    }
}

