/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import omtteam.omlib.power.OMEnergyStorage;
import omtteam.omlib.tileentity.TileEntityContainerElectric;
import omtteam.omlib.util.EnumMachineMode;

public abstract class TileEntityMachine
extends TileEntityContainerElectric {
    protected boolean active;
    protected boolean redstone = false;
    protected EnumMachineMode mode;
    protected FluidTank tank = new FluidTank(4000);

    public TileEntityMachine() {
        this.storage = new OMEnergyStorage(10, 10);
        this.active = true;
        this.mode = EnumMachineMode.INVERTED;
    }

    public void toggleMode() {
        this.mode = this.mode.ordinal() < EnumMachineMode.values().length - 1 ? EnumMachineMode.values()[this.mode.ordinal() + 1] : EnumMachineMode.values()[0];
        this.refreshActive(this.mode);
    }

    protected void refreshActive(EnumMachineMode mode) {
        switch (mode) {
            case INVERTED: {
                this.active = !this.redstone;
                break;
            }
            case NONINVERTED: {
                this.active = this.redstone;
                break;
            }
            case ALWAYS_ON: {
                this.active = true;
                break;
            }
            case ALWAYS_OFF: {
                this.active = false;
            }
        }
    }

    public EnumMachineMode getMode() {
        return this.mode;
    }

    public void setMode(EnumMachineMode mode) {
        this.mode = mode;
        this.refreshActive(this.mode);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("active", this.active);
        tag.func_74757_a("redstone", this.redstone);
        if (this.getTank() != null) {
            NBTTagCompound tank = new NBTTagCompound();
            this.getTank().writeToNBT(tank);
            tag.func_74782_a("tank", (NBTBase)tank);
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (this.getTank() != null && tag.func_74764_b("tank")) {
            this.getTank().readFromNBT(tag.func_74775_l("tank"));
        }
        this.active = !tag.func_74764_b("active") || tag.func_74767_n("active");
        this.redstone = tag.func_74767_n("redstone");
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean getRedstone() {
        return this.redstone;
    }

    public void setRedstone(boolean redstone) {
        this.redstone = redstone;
        this.refreshActive(this.mode);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getTank() != null || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getTank() != null) {
            return (T)this.getCapabilityTank(facing);
        }
        return super.getCapability(capability, facing);
    }

    @Nullable
    public abstract FluidTank getTank();

    @Nullable
    public abstract FluidTank getCapabilityTank(EnumFacing var1);
}

