/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.inventory.cell;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.the9grounds.aeadditions.api.AEAApi;
import com.the9grounds.aeadditions.api.IExternalGasStorageHandler;
import com.the9grounds.aeadditions.api.gas.IAEGasStack;
import com.the9grounds.aeadditions.inventory.cell.IHandlerPartBase;
import com.the9grounds.aeadditions.part.gas.PartGasStorage;
import com.the9grounds.aeadditions.util.GasUtil;
import com.the9grounds.aeadditions.util.MachineSource;
import com.the9grounds.aeadditions.util.StorageChannels;
import java.util.HashSet;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;

public class HandlerPartStorageGas
implements IHandlerPartBase<IAEGasStack> {
    protected PartGasStorage node;
    protected IGasHandler tank;
    protected AccessRestriction access = AccessRestriction.READ_WRITE;
    protected HashSet<Fluid> prioritizedFluids = new HashSet();
    protected boolean inverted;
    protected TileEntity tile = null;
    private IExternalGasStorageHandler externalHandler = null;
    public IStorageMonitorableAccessor externalSystem;

    public HandlerPartStorageGas(PartGasStorage _node) {
        this.node = _node;
    }

    public boolean canAccept(IAEGasStack input) {
        if (!this.node.isActive()) {
            return false;
        }
        if (this.tank == null && this.externalSystem == null && this.externalHandler == null || this.access != AccessRestriction.WRITE && this.access != AccessRestriction.READ_WRITE || input == null) {
            return false;
        }
        if (this.externalHandler != null) {
            IMEInventory<IAEGasStack> inventory2 = this.externalHandler.getInventory(this.tile, this.node.getFacing().func_176734_d(), new MachineSource(this.node));
            if (inventory2 == null) {
                return false;
            }
        } else {
            return false;
        }
        if (this.inverted) {
            return !this.prioritizedFluids.isEmpty() || !this.isPrioritized(input);
        }
        return this.prioritizedFluids.isEmpty() || this.isPrioritized(input);
    }

    public IAEGasStack extractItems(IAEGasStack request, Actionable mode, IActionSource src) {
        if (!this.node.isActive() || this.access != AccessRestriction.READ && this.access != AccessRestriction.READ_WRITE) {
            return null;
        }
        if (this.externalHandler != null && request != null) {
            IMEInventory<IAEGasStack> inventory2 = this.externalHandler.getInventory(this.tile, this.node.getFacing().func_176734_d(), new MachineSource(this.node));
            if (inventory2 == null) {
                return null;
            }
            return (IAEGasStack)inventory2.extractItems((IAEStack)request, mode, (IActionSource)new MachineSource(this.node));
        }
        return null;
    }

    public AccessRestriction getAccess() {
        return this.access;
    }

    public IItemList<IAEGasStack> getAvailableItems(IItemList<IAEGasStack> out) {
        if (!this.node.isActive() || this.access != AccessRestriction.READ && this.access != AccessRestriction.READ_WRITE) {
            return out;
        }
        if (this.externalHandler != null) {
            IMEInventory<IAEGasStack> inventory2 = this.externalHandler.getInventory(this.tile, this.node.getFacing().func_176734_d(), new MachineSource(this.node));
            if (inventory2 == null) {
                return out;
            }
            IItemList list = inventory2.getAvailableItems(StorageChannels.GAS.createList());
            for (IAEGasStack stack : list) {
                if (!this.isPrioritized(stack)) continue;
                out.add((IAEStack)stack);
            }
        }
        return out;
    }

    public IStorageChannel getChannel() {
        return StorageChannels.GAS;
    }

    public int getPriority() {
        return this.node.getPriority();
    }

    public int getSlot() {
        return 0;
    }

    public IAEGasStack injectItems(IAEGasStack input, Actionable mode, IActionSource src) {
        if (this.access != AccessRestriction.WRITE && this.access != AccessRestriction.READ_WRITE) {
            return input;
        }
        if (this.externalHandler != null && input != null) {
            IMEInventory<IAEGasStack> inventory2 = this.externalHandler.getInventory(this.tile, this.node.getFacing().func_176734_d(), new MachineSource(this.node));
            if (inventory2 == null) {
                return null;
            }
            return (IAEGasStack)inventory2.injectItems((IAEStack)input, mode, (IActionSource)new MachineSource(this.node));
        }
        return input;
    }

    public boolean isPrioritized(IAEGasStack input) {
        if (input == null) {
            return false;
        }
        Fluid gasFluid = GasUtil.getFluidStack((GasStack)input.getGasStack()).getFluid();
        return this.prioritizedFluids.size() == 0 || !this.inverted && this.prioritizedFluids.contains(gasFluid) || this.inverted && !this.prioritizedFluids.contains(gasFluid);
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void onListUpdate() {
    }

    @Override
    public void onNeighborChange() {
        TileEntity tileEntity;
        this.tank = null;
        EnumFacing orientation = this.node.getFacing();
        TileEntity hostTile = this.node.getHostTile();
        if (hostTile == null) {
            return;
        }
        if (hostTile.func_145831_w() == null) {
            return;
        }
        this.tile = tileEntity = hostTile.func_145831_w().func_175625_s(hostTile.func_174877_v().func_177972_a(orientation));
        this.tank = null;
        this.externalSystem = null;
        if (tileEntity == null) {
            this.externalHandler = null;
            return;
        }
        this.externalHandler = AEAApi.instance().getHandler(tileEntity, this.node.getFacing().func_176734_d(), new MachineSource(this.node));
    }

    public void postChange(IBaseMonitor<IAEGasStack> monitor, Iterable<IAEGasStack> change, IActionSource actionSource) {
        IGridNode gridNode = this.node.getGridNode();
        if (gridNode != null) {
            IGrid grid = gridNode.getGrid();
            if (grid != null) {
                grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                gridNode.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(this.node.getGridBlock().getFluidMonitor(), (IStorageChannel)StorageChannels.FLUID));
            }
            this.node.getHost().markForUpdate();
        }
    }

    @Override
    public void setAccessRestriction(AccessRestriction access) {
        this.access = access;
    }

    @Override
    public void setInverted(boolean _inverted) {
        this.inverted = _inverted;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public void setPrioritizedFluids(Fluid[] _fluids) {
        this.prioritizedFluids.clear();
        for (Fluid fluid : _fluids) {
            if (fluid == null) continue;
            this.prioritizedFluids.add(fluid);
        }
    }

    public boolean validForPass(int i) {
        return true;
    }
}

