/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item.storage;

import com.google.common.collect.ImmutableList;
import com.the9grounds.aeadditions.config.CellConfig;
import com.the9grounds.aeadditions.item.storage.StorageType;
import com.the9grounds.aeadditions.registries.CellDefinition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class StorageRegistry
implements Iterable<StorageType> {
    public ImmutableList<StorageType> types;
    public String name;

    private StorageRegistry(ImmutableList<StorageType> types, String name) {
        this.types = types;
        this.name = name;
    }

    @Override
    public Iterator<StorageType> iterator() {
        return this.types.iterator();
    }

    public StorageType fromMeta(int meta) {
        if (meta >= this.types.size()) {
            return (StorageType)this.types.get(0);
        }
        return (StorageType)this.types.get(meta);
    }

    public static class Builder {
        private List<StorageType> types = new LinkedList<StorageType>();
        private String name;

        public Builder(String name) {
            this.name = name;
        }

        public void add(CellDefinition definition, String cellName, CellConfig config) {
            this.types.add(new StorageType(definition, this.types.size(), cellName, config.getEnabled(), config.getNumberOfTypes(), config.getSize(), this.name));
        }

        public int size() {
            return this.types.size();
        }

        public StorageRegistry build() {
            return new StorageRegistry(ImmutableList.copyOf(this.types), this.name);
        }
    }
}

