/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.network;

import com.google.common.base.Preconditions;
import com.the9grounds.aeadditions.network.packet.IPacketHandlerClient;
import com.the9grounds.aeadditions.network.packet.IPacketHandlerServer;
import com.the9grounds.aeadditions.network.packet.PacketBufferEC;
import com.the9grounds.aeadditions.network.packet.PacketCrafterCapacity;
import com.the9grounds.aeadditions.network.packet.PacketCrafterDroppedItem;
import com.the9grounds.aeadditions.network.packet.PacketFluidFillerSlotUpdate;
import com.the9grounds.aeadditions.network.packet.PacketFluidFillerSyncClient;
import com.the9grounds.aeadditions.network.packet.PacketGasInterface;
import com.the9grounds.aeadditions.network.packet.PacketGasInterfaceServer;
import com.the9grounds.aeadditions.network.packet.PacketId;
import com.the9grounds.aeadditions.network.packet.other.PacketFluidContainerSlot;
import com.the9grounds.aeadditions.network.packet.other.PacketFluidSlotSelect;
import com.the9grounds.aeadditions.network.packet.other.PacketFluidSlotUpdate;
import com.the9grounds.aeadditions.network.packet.part.PacketFluidInterface;
import com.the9grounds.aeadditions.network.packet.part.PacketOreDictExport;
import com.the9grounds.aeadditions.network.packet.part.PacketPartConfig;
import com.the9grounds.aeadditions.network.packet.part.PacketStorageOpenContainer;
import com.the9grounds.aeadditions.network.packet.part.PacketStorageSelectFluid;
import com.the9grounds.aeadditions.network.packet.part.PacketStorageUpdateFluid;
import com.the9grounds.aeadditions.network.packet.part.PacketStorageUpdateState;
import com.the9grounds.aeadditions.network.packet.part.PacketTerminalOpenContainer;
import com.the9grounds.aeadditions.network.packet.part.PacketTerminalSelectFluidClient;
import com.the9grounds.aeadditions.network.packet.part.PacketTerminalSelectFluidServer;
import com.the9grounds.aeadditions.network.packet.part.PacketTerminalUpdateFluid;
import com.the9grounds.aeadditions.util.Log;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketHandler {
    public static final String CHANNEL_ID = "aeadditions";
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("aeadditions");

    public PacketHandler() {
        this.channel.register((Object)this);
    }

    public static void registerServerPackets() {
        PacketId.FLUID_SLOT.registerHandler(new PacketFluidSlotSelect.Handler());
        PacketId.FLUID_CONTAINER_SLOT.registerHandler(new PacketFluidContainerSlot.Handler());
        PacketId.EXPORT_ORE.registerHandler(new PacketOreDictExport.HandlerServer());
        PacketId.TERMINAL_SELECT_FLUID.registerHandler(new PacketTerminalSelectFluidServer.Handler());
        PacketId.TERMINAL_OPEN_CONTAINER.registerHandler(new PacketTerminalOpenContainer.Handler());
        PacketId.STORAGE_OPEN_CONTAINER.registerHandler(new PacketStorageOpenContainer.Handler());
        PacketId.STORAGE_SELECT_FLUID.registerHandler(new PacketStorageSelectFluid.Handler());
        PacketId.PART_CONFIG.registerHandler(new PacketPartConfig.HandlerServer());
        PacketId.FLUID_FILLER_SYNC_CLIENT.registerHandler(new PacketFluidFillerSyncClient.HandlerServer());
        PacketId.GAS_INTERFACE_SERVER.registerHandler(new PacketGasInterfaceServer.HandlerServer());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerClientPackets() {
        PacketId.FLUID_SLOT.registerHandler(new PacketFluidSlotUpdate.Handler());
        PacketId.FLUID_INTERFACE.registerHandler(new PacketFluidInterface.Handler());
        PacketId.EXPORT_ORE.registerHandler(new PacketOreDictExport.HandlerClient());
        PacketId.TERMINAL_UPDATE_FLUID.registerHandler(new PacketTerminalUpdateFluid.Handler());
        PacketId.TERMINAL_SELECT_FLUID.registerHandler(new PacketTerminalSelectFluidClient.Handler());
        PacketId.STORAGE_UPDATE_FLUID.registerHandler(new PacketStorageUpdateFluid.Handler());
        PacketId.STORAGE_UPDATE_STATE.registerHandler(new PacketStorageUpdateState.Handler());
        PacketId.PART_CONFIG.registerHandler(new PacketPartConfig.HandlerClient());
        PacketId.FLUID_CRAFTER_CAPACITY.registerHandler(new PacketCrafterCapacity.Companion.HandlerClient());
        PacketId.FLUID_CRAFTER_DROPPED_ITEM.registerHandler(new PacketCrafterDroppedItem.Companion.HandlerClient());
        PacketId.FLUID_FILLER_SLOT_UPDATE.registerHandler(new PacketFluidFillerSlotUpdate.Companion.HandlerClient());
        PacketId.GAS_INTERFACE.registerHandler(new PacketGasInterface.Handler());
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBufferEC data = new PacketBufferEC(event.getPacket().payload());
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        byte packetIdOrdinal = data.readByte();
        PacketId packetId = PacketId.values()[packetIdOrdinal];
        IPacketHandlerServer packetHandler = packetId.getHandlerServer();
        PacketHandler.checkThreadAndEnqueue(packetHandler, data, player, (IThreadListener)player.func_71121_q());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        PacketBufferEC data = new PacketBufferEC(event.getPacket().payload());
        byte packetIdOrdinal = data.readByte();
        PacketId packetId = PacketId.values()[packetIdOrdinal];
        IPacketHandlerClient packetHandler = packetId.getHandlerClient();
        PacketHandler.checkThreadAndEnqueue(packetHandler, data, (IThreadListener)Minecraft.func_71410_x());
    }

    public void sendPacket(FMLProxyPacket packet, EntityPlayerMP player) {
        this.channel.sendTo(packet, player);
    }

    @SideOnly(value=Side.CLIENT)
    private static void checkThreadAndEnqueue(IPacketHandlerClient packet, PacketBufferEC data, IThreadListener threadListener) {
        if (!threadListener.func_152345_ab()) {
            data.retain();
            threadListener.func_152344_a(() -> {
                try {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    Preconditions.checkNotNull((Object)player, (Object)"Tried to send data to client before the player exists.");
                    packet.onPacketData(data, (EntityPlayer)player);
                }
                catch (IOException e) {
                    Log.error("Network Error", e);
                }
                finally {
                    data.release();
                }
            });
        }
    }

    private static void checkThreadAndEnqueue(IPacketHandlerServer packet, PacketBufferEC data, EntityPlayerMP player, IThreadListener threadListener) {
        if (!threadListener.func_152345_ab()) {
            data.retain();
            threadListener.func_152344_a(() -> {
                try {
                    packet.onPacketData(data, player);
                }
                catch (IOException e) {
                    Log.error("Network Error", e);
                }
                finally {
                    data.release();
                }
            });
        }
    }
}

