/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.smelter;

import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.TileSmelter;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.JEIPluginTE;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class SmelterRecipeWrapper
extends BaseRecipeWrapper {
    protected List<List<ItemStack>> inputs;
    protected List<FluidStack> inputFluids;
    protected List<ItemStack> outputs;
    protected int chance;
    protected IDrawableAnimated fluid;
    protected IDrawableAnimated progress;
    protected IDrawableAnimated speed;

    public SmelterRecipeWrapper(IGuiHelper guiHelper, SmelterManager.SmelterRecipe recipe) {
        this(guiHelper, recipe, "thermalexpansion.smelter");
    }

    public SmelterRecipeWrapper(IGuiHelper guiHelper, SmelterManager.SmelterRecipe recipe, String uIdIn) {
        this.uId = uIdIn;
        ArrayList<List<ItemStack>> recipeInputs = new ArrayList<List<ItemStack>>();
        ArrayList<FluidStack> recipeInputFluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> recipeInputsPrimary = new ArrayList<ItemStack>();
        ArrayList<ItemStack> recipeInputsSecondary = new ArrayList<ItemStack>();
        int oreID = SmelterManager.convertInput((ItemStack)recipe.getPrimaryInput()).oreID;
        if (oreID != -1) {
            for (ItemStack ore : OreDictionary.getOres((String)ItemHelper.oreProxy.getOreName(oreID), (boolean)false)) {
                recipeInputsPrimary.add(ItemHelper.cloneStack((ItemStack)ore, (int)recipe.getPrimaryInput().func_190916_E()));
            }
        } else {
            recipeInputsPrimary.add(recipe.getPrimaryInput());
        }
        oreID = SmelterManager.convertInput((ItemStack)recipe.getSecondaryInput()).oreID;
        if (oreID != -1) {
            for (ItemStack ore : OreDictionary.getOres((String)ItemHelper.oreProxy.getOreName(oreID), (boolean)false)) {
                recipeInputsSecondary.add(ItemHelper.cloneStack((ItemStack)ore, (int)recipe.getSecondaryInput().func_190916_E()));
            }
        } else {
            recipeInputsSecondary.add(recipe.getSecondaryInput());
        }
        recipeInputs.add(recipeInputsSecondary);
        recipeInputs.add(recipeInputsPrimary);
        if (this.uId.equals("thermalexpansion.smelter_pyrotheum")) {
            recipeInputFluids.add(new FluidStack(TFFluids.fluidPyrotheum, 100));
            this.inputFluids = recipeInputFluids;
            recipeOutputs.add(ItemHelper.cloneStack((ItemStack)recipe.getPrimaryOutput(), (int)TileSmelter.getPyrotheumOutputAmount(recipe.getPrimaryOutput())));
            this.energy = recipe.getEnergy() * 150 / 100;
        } else {
            this.inputFluids = Collections.emptyList();
            recipeOutputs.add(recipe.getPrimaryOutput());
            this.energy = recipe.getEnergy();
        }
        if (recipe.getSecondaryOutput() != null) {
            recipeOutputs.add(recipe.getSecondaryOutput());
        }
        this.inputs = recipeInputs;
        this.outputs = recipeOutputs;
        this.chance = recipe.getSecondaryOutputChance();
        IDrawableStatic fluidDrawable = Drawables.getDrawables(guiHelper).getProgress(1);
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(this.uId.equals("thermalexpansion.smelter_pyrotheum") ? 1 : 0);
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(4);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        int basePower = TileSmelter.basePower;
        this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, Math.max(10, this.energy / basePower), IDrawableAnimated.StartDirection.LEFT, true);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, Math.max(10, this.energy / basePower), IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setInputs(FluidStack.class, this.inputFluids);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.uId.equals("thermalexpansion.smelter_pyrotheum")) {
            JEIPluginTE.drawFluid(69, 23, this.inputFluids.get(0), 24, 16);
            this.fluid.draw(minecraft, 69, 23);
        }
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 34, 33);
        this.energyMeter.draw(minecraft, 2, 8);
        if (this.chance > 0) {
            String dispChance = StringHelper.formatNumber((long)this.chance) + "%";
            minecraft.field_71466_p.func_78276_b(dispChance, 102 - 6 * dispChance.length(), 48, 0x808080);
        }
    }
}

