/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.inventory.SlotPhantom;
import me.desht.pneumaticcraft.common.inventory.SlotPhantomUnstackable;
import me.desht.pneumaticcraft.common.item.ItemLogisticsFrame;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ContainerLogistics
extends ContainerPneumaticBase {
    public final SemiBlockLogistics logistics;
    private final boolean itemContainer;

    public ContainerLogistics(InventoryPlayer inventoryPlayer, SemiBlockLogistics logistics) {
        super(null);
        boolean bl = this.itemContainer = logistics == null;
        if (this.itemContainer) {
            logistics = ContainerLogistics.getLogistics(inventoryPlayer.field_70458_d, this.getHeldLogisticsFrame(inventoryPlayer.field_70458_d));
        }
        this.logistics = logistics;
        if (logistics != null) {
            this.addSyncedFields(logistics);
            IItemHandlerModifiable requests = logistics.getFilters();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a((Slot)(logistics.canFilterStack() ? new SlotPhantom((IItemHandler)requests, y * 9 + x, x * 18 + 8, y * 18 + 29) : new SlotPhantomUnstackable((IItemHandler)requests, y * 9 + x, x * 18 + 8, y * 18 + 29)));
                }
            }
            this.addPlayerSlots(inventoryPlayer, 134);
        }
    }

    private static SemiBlockLogistics getLogistics(EntityPlayer player, ItemStack stack) {
        return ContainerLogistics.getLogistics(player.field_70170_p, player, stack);
    }

    public static SemiBlockLogistics getLogistics(World world, ItemStack stack) {
        return ContainerLogistics.getLogistics(world, null, stack);
    }

    private static SemiBlockLogistics getLogistics(World world, EntityPlayer player, ItemStack stack) {
        SemiBlockLogistics logistics;
        if (stack.func_77973_b() instanceof ItemLogisticsFrame && (logistics = (SemiBlockLogistics)SemiBlockManager.getSemiBlockForKey(((ItemLogisticsFrame)stack.func_77973_b()).semiBlockId)) != null) {
            logistics.initialize(world, BlockPos.field_177992_a);
            logistics.onPlaced(player, stack, null);
            return logistics;
        }
        return null;
    }

    public boolean isItemContainer() {
        return this.itemContainer;
    }

    public void func_75134_a(EntityPlayer player) {
        ItemStack logisticsStack;
        if (this.itemContainer && this.logistics != null && !(logisticsStack = this.getHeldLogisticsFrame(player)).func_190926_b()) {
            NonNullList drops = NonNullList.func_191196_a();
            this.logistics.addDrops((NonNullList<ItemStack>)drops);
            NBTTagCompound settingTag = ((ItemStack)drops.get(0)).func_77978_p();
            logisticsStack.func_77982_d(settingTag != null ? settingTag.func_74737_b() : null);
        }
    }

    private ItemStack getHeldLogisticsFrame(EntityPlayer player) {
        if (player.func_184614_ca().func_77973_b() instanceof ItemLogisticsFrame) {
            return player.func_184614_ca();
        }
        if (player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof ItemLogisticsFrame) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        super.handleGUIButtonPress(guiID, player);
        if (this.logistics != null) {
            this.logistics.handleGUIButtonPress(guiID, player);
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return this.logistics != null && !this.logistics.isInvalid();
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotIndex) {
        Slot srcSlot = (Slot)this.field_75151_b.get(slotIndex);
        if (slotIndex >= this.playerSlotsStart && srcSlot != null && srcSlot.func_75216_d()) {
            ItemStack stackInSlot = srcSlot.func_75211_c();
            for (int i = 0; i < 27; ++i) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                if (slot.func_75216_d()) continue;
                slot.func_75215_d(stackInSlot.func_77946_l());
                slot.func_75211_c().func_190920_e(slot.func_75219_a());
                break;
            }
        }
        return ItemStack.field_190927_a;
    }
}

