/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TrashCanBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    public static final int DEFAULT_ENERGY_LIMIT = 10000;
    public static final int MAX_ENERGY_LIMIT = 10000000;
    public static final int MIN_ENERGY_LIMIT = 1;
    public final IItemHandler ITEM_HANDLER = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            for (ItemStack filter : TrashCanBlockEntity.this.itemFilter) {
                if (filter.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)filter)) continue;
                return TrashCanBlockEntity.this.itemFilterWhitelist ? ItemStack.field_190927_a : stack;
            }
            return TrashCanBlockEntity.this.itemFilterWhitelist ? stack : ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            for (ItemStack filter : TrashCanBlockEntity.this.itemFilter) {
                if (filter.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)filter)) continue;
                return TrashCanBlockEntity.this.itemFilterWhitelist;
            }
            return !TrashCanBlockEntity.this.itemFilterWhitelist;
        }
    };
    public final IFluidHandler FLUID_HANDLER = new IFluidHandler(){

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    return null;
                }

                public int getCapacity() {
                    return Integer.MAX_VALUE;
                }

                public boolean canFill() {
                    return true;
                }

                public boolean canDrain() {
                    return false;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return fluidStack == null || this.isFluidValid(0, fluidStack);
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return false;
                }
            }};
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            if (stack == null) {
                return false;
            }
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(stack)) continue;
                return TrashCanBlockEntity.this.liquidFilterWhitelist;
            }
            return !TrashCanBlockEntity.this.liquidFilterWhitelist;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(resource)) continue;
                return TrashCanBlockEntity.this.liquidFilterWhitelist ? resource.amount : 0;
            }
            return TrashCanBlockEntity.this.liquidFilterWhitelist ? 0 : resource.amount;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    };
    public final IItemHandler LIQUID_ITEM_HANDLER = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            TrashCanBlockEntity.this.liquidItem = stack;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return TrashCanBlockEntity.this.liquidItem;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack) || !TrashCanBlockEntity.this.liquidItem.func_190926_b() || stack.func_190926_b()) {
                return stack;
            }
            if (!simulate) {
                TrashCanBlockEntity.this.liquidItem = stack.func_77946_l();
                TrashCanBlockEntity.this.liquidItem.func_190920_e(1);
                TrashCanBlockEntity.this.dataChanged();
            }
            ItemStack stack1 = stack.func_77946_l();
            stack1.func_190918_g(1);
            return stack1;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0 || TrashCanBlockEntity.this.liquidItem.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = TrashCanBlockEntity.this.liquidItem.func_77946_l();
            stack.func_190920_e(Math.min(amount, stack.func_190916_E()));
            if (!simulate) {
                TrashCanBlockEntity.this.liquidItem.func_190918_g(amount);
                TrashCanBlockEntity.this.dataChanged();
            }
            return stack;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            boolean filtered = !TrashCanBlockEntity.this.liquidFilterWhitelist;
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(stack)) continue;
                filtered = TrashCanBlockEntity.this.liquidFilterWhitelist;
                break;
            }
            if (!filtered) {
                return false;
            }
            if (Compatibility.MEKANISM.doesItemHaveGasStored(stack)) {
                return true;
            }
            if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                return false;
            }
            IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (handler == null) {
                return false;
            }
            IFluidTankProperties[] properties = handler.getTankProperties();
            if (properties == null) {
                return false;
            }
            for (IFluidTankProperties property : properties) {
                if (property == null || !property.canDrain() || property.getContents() == null || property.getContents().amount <= 0) continue;
                return true;
            }
            return false;
        }
    };
    public final IEnergyStorage ENERGY_STORAGE = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return TrashCanBlockEntity.this.useEnergyLimit ? Math.min(maxReceive, TrashCanBlockEntity.this.energyLimit) : maxReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    };
    public final IItemHandler ENERGY_ITEM_HANDLER = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            TrashCanBlockEntity.this.energyItem = stack;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return TrashCanBlockEntity.this.energyItem;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack) || !TrashCanBlockEntity.this.energyItem.func_190926_b() || stack.func_190926_b()) {
                return stack;
            }
            if (!simulate) {
                TrashCanBlockEntity.this.energyItem = stack.func_77946_l();
                TrashCanBlockEntity.this.energyItem.func_190920_e(1);
                TrashCanBlockEntity.this.dataChanged();
            }
            ItemStack stack1 = stack.func_77946_l();
            stack1.func_190918_g(1);
            return stack1;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0 || TrashCanBlockEntity.this.energyItem.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = TrashCanBlockEntity.this.energyItem.func_77946_l();
            stack.func_190920_e(Math.min(amount, stack.func_190916_E()));
            if (!simulate) {
                TrashCanBlockEntity.this.energyItem.func_190918_g(amount);
                TrashCanBlockEntity.this.dataChanged();
            }
            return stack;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (!stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                return false;
            }
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return storage != null && storage.canExtract() && storage.getEnergyStored() > 0;
        }
    };
    public final boolean items;
    public final ArrayList<ItemStack> itemFilter = new ArrayList();
    public boolean itemFilterWhitelist = false;
    public final boolean liquids;
    public final ArrayList<ItemFilter> liquidFilter = new ArrayList();
    public boolean liquidFilterWhitelist = false;
    public ItemStack liquidItem = ItemStack.field_190927_a;
    public final boolean energy;
    public int energyLimit = 10000;
    public boolean useEnergyLimit = false;
    public ItemStack energyItem = ItemStack.field_190927_a;

    public TrashCanBlockEntity(BaseBlockEntityType<?> blockEntityType, boolean items, boolean liquids, boolean energy) {
        super(blockEntityType);
        this.items = items;
        this.liquids = liquids;
        this.energy = energy;
        for (int i = 0; i < 9; ++i) {
            this.itemFilter.add(ItemStack.field_190927_a);
            this.liquidFilter.add(null);
        }
    }

    public void func_73660_a() {
        IEnergyStorage energyStorage;
        if (this.liquids && !this.liquidItem.func_190926_b() && this.liquidItem.func_77973_b() != Items.field_151133_ar) {
            IFluidTankProperties[] properties;
            IFluidHandlerItem fluidHandler;
            if (this.liquidItem.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (fluidHandler = (IFluidHandlerItem)this.liquidItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null && (properties = fluidHandler.getTankProperties()) != null) {
                boolean changed = false;
                for (IFluidTankProperties property : properties) {
                    if (property.getContents() == null || !property.canDrain() || property.getContents().amount <= 0) continue;
                    fluidHandler.drain(property.getContents(), true);
                    changed = true;
                }
                if (changed) {
                    this.liquidItem = fluidHandler.getContainer();
                    this.dataChanged();
                }
            }
            if (Compatibility.MEKANISM.drainGasFromItem(this.liquidItem)) {
                this.dataChanged();
            }
        }
        if (this.energy && !this.energyItem.func_190926_b() && this.energyItem.hasCapability(CapabilityEnergy.ENERGY, null) && (energyStorage = (IEnergyStorage)this.energyItem.getCapability(CapabilityEnergy.ENERGY, null)) != null && energyStorage.canExtract() && energyStorage.getEnergyStored() > 0) {
            energyStorage.extractEnergy(energyStorage.getEnergyStored(), false);
            this.dataChanged();
        }
    }

    public boolean hasCapability(Capability<?> cap, @Nullable EnumFacing facing) {
        return this.items && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || this.liquids && (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || Compatibility.MEKANISM.isInstalled() && cap == Compatibility.MEKANISM.getGasHandlerCapability()) || this.energy && cap == CapabilityEnergy.ENERGY || super.hasCapability(cap, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> cap, @Nullable EnumFacing facing) {
        if (this.items && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.ITEM_HANDLER);
        }
        if (this.liquids) {
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.FLUID_HANDLER);
            }
            if (Compatibility.MEKANISM.isInstalled() && cap == Compatibility.MEKANISM.getGasHandlerCapability()) {
                return (T)Compatibility.MEKANISM.getGasHandler(this.liquidFilter, () -> this.liquidFilterWhitelist);
            }
        }
        if (this.energy && cap == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.ENERGY_STORAGE);
        }
        return (T)super.getCapability(cap, facing);
    }

    protected NBTTagCompound writeData() {
        int i;
        NBTTagCompound tag = new NBTTagCompound();
        if (this.items) {
            for (i = 0; i < this.itemFilter.size(); ++i) {
                tag.func_74782_a("itemFilter" + i, (NBTBase)this.itemFilter.get(i).serializeNBT());
            }
            tag.func_74757_a("itemFilterWhitelist", this.itemFilterWhitelist);
        }
        if (this.liquids) {
            for (i = 0; i < this.liquidFilter.size(); ++i) {
                if (this.liquidFilter.get(i) == null) continue;
                tag.func_74782_a("liquidFilter" + i, (NBTBase)LiquidTrashCanFilters.write(this.liquidFilter.get(i)));
            }
            tag.func_74757_a("liquidFilterWhitelist", this.liquidFilterWhitelist);
            if (!this.liquidItem.func_190926_b()) {
                tag.func_74782_a("liquidItem", (NBTBase)this.liquidItem.serializeNBT());
            }
        }
        if (this.energy) {
            tag.func_74757_a("useEnergyLimit", this.useEnergyLimit);
            tag.func_74768_a("energyLimit", this.energyLimit);
            if (!this.energyItem.func_190926_b()) {
                tag.func_74782_a("energyItem", (NBTBase)this.energyItem.serializeNBT());
            }
        }
        return tag;
    }

    protected void readData(NBTTagCompound tag) {
        int i;
        if (this.items) {
            for (i = 0; i < this.itemFilter.size(); ++i) {
                this.itemFilter.set(i, tag.func_74764_b("itemFilter" + i) ? new ItemStack(tag.func_74775_l("itemFilter" + i)) : ItemStack.field_190927_a);
            }
            boolean bl = this.itemFilterWhitelist = tag.func_74764_b("itemFilterWhitelist") && tag.func_74767_n("itemFilterWhitelist");
        }
        if (this.liquids) {
            for (i = 0; i < this.liquidFilter.size(); ++i) {
                this.liquidFilter.set(i, tag.func_74764_b("liquidFilter" + i) ? LiquidTrashCanFilters.read(tag.func_74775_l("liquidFilter" + i)) : null);
            }
            this.liquidFilterWhitelist = tag.func_74764_b("liquidFilterWhitelist") && tag.func_74767_n("liquidFilterWhitelist");
            ItemStack itemStack = this.liquidItem = tag.func_74764_b("liquidItem") ? new ItemStack(tag.func_74775_l("liquidItem")) : ItemStack.field_190927_a;
        }
        if (this.energy) {
            this.useEnergyLimit = tag.func_74764_b("useEnergyLimit") && tag.func_74767_n("useEnergyLimit");
            this.energyLimit = tag.func_74764_b("energyLimit") ? tag.func_74762_e("energyLimit") : 10000;
            this.energyItem = tag.func_74764_b("energyItem") ? new ItemStack(tag.func_74775_l("energyItem")) : ItemStack.field_190927_a;
        }
    }
}

