/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.screen;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.ObjectBaseContainerWidget;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class TrashCanScreen<T extends TrashCanContainer>
extends ObjectBaseContainerWidget<TrashCanBlockEntity, T> {
    private final ITextComponent title;

    public TrashCanScreen(String title) {
        super(0, 0, 1, 1);
        this.title = TextComponents.translation((String)title).get();
    }

    protected ITextComponent getNarrationMessage(TrashCanBlockEntity object) {
        return this.title;
    }

    protected TrashCanBlockEntity getObject(TrashCanBlockEntity oldObject) {
        return ((TrashCanContainer)this.container).getBlockEntity();
    }

    protected boolean validateObject(TrashCanBlockEntity object) {
        return object != null && !object.func_145837_r();
    }

    protected int width(TrashCanBlockEntity object) {
        return ((TrashCanContainer)this.container).width;
    }

    protected int height(TrashCanBlockEntity object) {
        return ((TrashCanContainer)this.container).height;
    }

    protected abstract String getBackground();

    protected void renderBackground(int mouseX, int mouseY, TrashCanBlockEntity entity) {
        super.renderBackground(mouseX, mouseY, (Object)entity);
        ScreenUtils.bindTexture((ResourceLocation)new ResourceLocation("trashcans", "textures/" + this.getBackground()));
        ScreenUtils.drawTexture((float)0.0f, (float)0.0f, (float)this.width(), (float)this.height());
    }

    protected void renderForeground(int mouseX, int mouseY, TrashCanBlockEntity entity) {
        super.renderForeground(mouseX, mouseY, (Object)entity);
        ScreenUtils.drawCenteredString((ITextComponent)this.title, (float)((float)this.width() / 2.0f), (float)6.0f);
        ScreenUtils.drawString((String)ClientUtils.getPlayer().field_71071_by.func_70005_c_(), (float)21.0f, (float)(this.height() - 94));
        this.drawText(entity);
    }

    protected abstract void drawText(TrashCanBlockEntity var1);
}

