/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.morechickens.core.configs;

import com.gendeathrow.morechickens.core.ChickensMore;
import com.gendeathrow.morechickens.core.configs.JsonConfig;
import com.setycz.chickens.handler.SpawnType;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;

public class ConfigHandler {
    public static final File configDir = new File("config/chickens");
    public static final File moreChickensFile = new File(configDir, "morechickens.json");
    private static JsonConfig config;
    public static ArrayList<String> ErrorList;

    public static void loadChickens(Collection<ChickensRegistryItem> allChickens) {
        config = new JsonConfig(moreChickensFile);
        config.Load();
        String comment = "_Comment";
        config.getString(comment, "_Name", "Just a Reference to the old system naming. Changing does nothing.");
        config.getString(comment, "_Is Enabled", "Is chicken enabled?");
        config.getString(comment, "_Lay Item", "Item the chicken will Lay.               modid:itemid:metadata:amount #example: minecraft:log:2:3");
        config.getString(comment, "_Drop Item", "Item the chicken drops on death.        modid:itemid:metadata:amount #example: minecraft:bone");
        config.getString(comment, "_Spawn Type", "Chicken spawn type, can be: " + String.join((CharSequence)",", SpawnType.names()));
        config.getString(comment, "_Parent 1", "First parent, empty if it cant be breed. modid:chickenid #example: chickens:waterchicken");
        config.getString(comment, "_Parent 2", "Second parent, empty if it cant be breed. ");
        for (ChickensRegistryItem chicken : allChickens) {
            String registryName = chicken.getRegistryName().toString();
            config.getString(registryName, "Name", chicken.getEntityName());
            boolean enabled = config.getBoolean(registryName, "Is Enabled", true);
            chicken.setEnabled(enabled);
            float layCoefficient = config.getFloat(registryName, "Lay Coefficient", 1.0f, 0.01f, 100.0f);
            chicken.setLayCoefficient(layCoefficient);
            chicken.setLayItem(ConfigHandler.loadItemStack(config, registryName, chicken, "Lay Item", chicken.createLayItem()));
            chicken.setDropItem(ConfigHandler.loadItemStack(config, registryName, chicken, "Drop Item", chicken.createDropItem()));
            SpawnType spawnType = SpawnType.valueOf((String)config.getString(registryName, "Spawn Type", chicken.getSpawnType().toString()));
            chicken.setSpawnType(spawnType);
            ChickensRegistry.register((ChickensRegistryItem)chicken);
            ChickensMore.proxy.registerChicken(chicken);
        }
        for (ChickensRegistryItem chicken : allChickens) {
            ChickensRegistryItem parent1 = ChickensRegistry.getByRegistryName((String)ConfigHandler.getChickenParent(config, "Parent 1", allChickens, chicken, chicken.getParent1()));
            ChickensRegistryItem parent2 = ChickensRegistry.getByRegistryName((String)ConfigHandler.getChickenParent(config, "Parent 2", allChickens, chicken, chicken.getParent2()));
            if (parent1 != null && parent2 != null) {
                chicken.setParentsNew(parent1, parent2);
                continue;
            }
            chicken.setNoParents();
        }
        if (ConfigHandler.config.hasChanged) {
            config.Save();
        }
    }

    private static String getChickenParent(JsonConfig configuration, String propertyName, Collection<ChickensRegistryItem> allChickens, ChickensRegistryItem chicken, ChickensRegistryItem parent) {
        String Category = chicken.getRegistryName().toString();
        return configuration.getString(Category, propertyName, parent != null ? parent.getRegistryName().toString() : "");
    }

    private static ItemStack loadItemStack(JsonConfig configuration, String Category, ChickensRegistryItem chicken, String prefix, ItemStack defaultItemStack) {
        ItemStack stack = configuration.getItemStack(Category, prefix, defaultItemStack);
        if (stack == null) {
            if (defaultItemStack != null) {
                return defaultItemStack;
            }
            throw new RuntimeException("Cannot find " + prefix + " for " + chicken.getRegistryName().toString());
        }
        return stack;
    }

    static {
        ErrorList = new ArrayList();
    }
}

