/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.item;

import java.util.function.Consumer;
import java.util.function.Function;
import me.paulf.wings.WingsMod;
import me.paulf.wings.server.block.WingsBlocks;
import me.paulf.wings.server.config.ConfigWingSettings;
import me.paulf.wings.server.config.WingsItemsConfig;
import me.paulf.wings.server.item.ItemWings;
import me.paulf.wings.server.item.group.ItemGroupWings;
import me.paulf.wings.util.CapabilityProviders;
import me.paulf.wings.util.Reg;
import me.paulf.wings.util.Util;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="wings")
@Mod.EventBusSubscriber(modid="wings")
public final class WingsItems {
    public static final Item FAIRY_DUST = (Item)Util.sneakyNull();
    public static final Item AMETHYST = (Item)Util.sneakyNull();
    public static final Item BAT_BLOOD = (Item)Util.sneakyNull();
    public static final Item ANGEL_WINGS = (Item)Util.sneakyNull();
    public static final Item SLIME_WINGS = (Item)Util.sneakyNull();
    public static final Item BLUE_BUTTERFLY_WINGS = (Item)Util.sneakyNull();
    public static final Item MONARCH_BUTTERFLY_WINGS = (Item)Util.sneakyNull();
    public static final Item FIRE_WINGS = (Item)Util.sneakyNull();
    public static final Item BAT_WINGS = (Item)Util.sneakyNull();
    public static final Item FAIRY_WINGS = (Item)Util.sneakyNull();
    public static final Item EVIL_WINGS = (Item)Util.sneakyNull();
    public static final Item DRAGON_WINGS = (Item)Util.sneakyNull();

    private WingsItems() {
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Item> event) {
        Item[] itemArray = new Item[14];
        itemArray[0] = Reg.createItem(WingsBlocks.FAIRY_DUST_ORE);
        itemArray[1] = Reg.createItem(WingsBlocks.AMETHYST_ORE);
        itemArray[2] = Reg.withName(new Item().func_77637_a((CreativeTabs)ItemGroupWings.instance()), "fairy_dust");
        itemArray[3] = Reg.withName(new Item().func_77637_a((CreativeTabs)ItemGroupWings.instance()), "amethyst");
        itemArray[4] = Reg.withName(new Item().func_77637_a((CreativeTabs)ItemGroupWings.instance()).func_77642_a(Items.field_151069_bo), "bat_blood");
        itemArray[5] = WingsItems.createWings(Names.ANGEL, WingsMod.instance()::createAvianWings, WingsItemsConfig.ANGEL);
        itemArray[6] = WingsItems.createWings(Names.SLIME, WingsMod.instance()::createInsectoidWings, WingsItemsConfig.SLIME);
        itemArray[7] = WingsItems.createWings(Names.BLUE_BUTTERFLY, WingsMod.instance()::createInsectoidWings, WingsItemsConfig.BLUE_BUTTERFLY);
        itemArray[8] = WingsItems.createWings(Names.MONARCH_BUTTERFLY, WingsMod.instance()::createInsectoidWings, WingsItemsConfig.MONARCH_BUTTERFLY);
        itemArray[9] = WingsItems.createWings(Names.FIRE, WingsMod.instance()::createAvianWings, WingsItemsConfig.FIRE);
        itemArray[10] = WingsItems.createWings(Names.BAT, WingsMod.instance()::createAvianWings, WingsItemsConfig.BAT);
        itemArray[11] = WingsItems.createWings(Names.FAIRY, WingsMod.instance()::createInsectoidWings, WingsItemsConfig.FAIRY);
        itemArray[12] = WingsItems.createWings(Names.EVIL, WingsMod.instance()::createAvianWings, WingsItemsConfig.EVIL);
        itemArray[13] = WingsItems.createWings(Names.DRAGON, WingsMod.instance()::createAvianWings, WingsItemsConfig.DRAGON);
        event.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
    }

    private static Item createWings(ResourceLocation name, Function<String, Consumer<CapabilityProviders.CompositeBuilder>> capabilities, ConfigWingSettings attributes) {
        return Reg.withName(ItemWings.create(capabilities.apply(name.func_110623_a().replace("_wings", "")), attributes.toImmutable()), name.func_110623_a()).func_77637_a(ItemGroupWings.instance());
    }

    public static final class Names {
        public static final ResourceLocation ANGEL = Names.create("angel_wings");
        public static final ResourceLocation SLIME = Names.create("slime_wings");
        public static final ResourceLocation BLUE_BUTTERFLY = Names.create("blue_butterfly_wings");
        public static final ResourceLocation MONARCH_BUTTERFLY = Names.create("monarch_butterfly_wings");
        public static final ResourceLocation FIRE = Names.create("fire_wings");
        public static final ResourceLocation BAT = Names.create("bat_wings");
        public static final ResourceLocation FAIRY = Names.create("fairy_wings");
        public static final ResourceLocation EVIL = Names.create("evil_wings");
        public static final ResourceLocation DRAGON = Names.create("dragon_wings");

        private Names() {
        }

        private static ResourceLocation create(String path) {
            return new ResourceLocation("wings", path);
        }
    }
}

